/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.famzangl.minecraft.minebot.MinebotSettings;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.commons.lang3.StringEscapeUtils;

public class PlayerUpdateHandler {
    private final ExecutorService sendThread;
    private final Hashtable<String, Long> blockTimes = new Hashtable();
    private boolean toLoaded;
    private String to;

    public PlayerUpdateHandler() {
        this.sendThread = Executors.newFixedThreadPool(2);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        if (this.toLoaded && this.to == null) {
            return;
        }
        EntityPlayer player = evt.player;
        String name = player.getDisplayName();
        Long blocked = this.blockTimes.get(name);
        if (blocked != null && blocked > System.currentTimeMillis()) {
            return;
        }
        this.blockTimes.put(name, System.currentTimeMillis() + 2000L);
        final String json = String.format("{\"players\":[{\"username\": \"%s\", \"x\": %d, \"y\" : %d, \"z\": %d, \"world\" : \"world\"}]}", StringEscapeUtils.escapeJava((String)name), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        this.sendThread.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HttpURLConnection connection = null;
                try {
                    String urlParameters = "players=" + URLEncoder.encode(json);
                    if (!PlayerUpdateHandler.this.toLoaded) {
                        PlayerUpdateHandler.this.to = new MinebotSettings().get("report_position_to", null);
                        PlayerUpdateHandler.this.toLoaded = true;
                    }
                    if (PlayerUpdateHandler.this.to == null) {
                        return;
                    }
                    URL url = new URL(PlayerUpdateHandler.this.to);
                    connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("POST");
                    connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    connection.setRequestProperty("Content-Length", Integer.toString(urlParameters.getBytes().length));
                    connection.setRequestProperty("Content-Language", "en-US");
                    connection.setUseCaches(false);
                    connection.setDoInput(true);
                    connection.setDoOutput(true);
                    DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
                    wr.writeBytes(urlParameters);
                    wr.flush();
                    wr.close();
                    InputStream is = connection.getInputStream();
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is));
                    while (rd.readLine() != null) {
                    }
                    rd.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                finally {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
        });
    }
}

