/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai;

import java.util.Arrays;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.HumanReadableItemFilter;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class BlockItemFilter
implements HumanReadableItemFilter {
    private final Block[] matched;

    public BlockItemFilter(Block ... matched) {
        this.matched = matched;
    }

    @Override
    public boolean matches(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() != null && itemStack.func_77973_b() instanceof ItemBlock && this.matchesItem(itemStack, (ItemBlock)itemStack.func_77973_b());
    }

    protected boolean matchesItem(ItemStack itemStack, ItemBlock item) {
        return AIHelper.blockIsOneOf(item.field_150939_a, this.matched);
    }

    public String toString() {
        return "BlockItemFilter [matched=" + Arrays.toString(this.matched) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.matched);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockItemFilter other = (BlockItemFilter)obj;
        return Arrays.equals(this.matched, other.matched);
    }

    @Override
    public String getDescription() {
        StringBuilder str = new StringBuilder();
        for (Block m : this.matched) {
            if (str.length() > 0) {
                str.append(", ");
            }
            str.append(m.func_149732_F());
        }
        return str.toString();
    }
}

