/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai;

import java.util.Arrays;
import net.minecraft.block.Block;

public class BlockWhitelist {
    public static int MAX_BLOCKIDS = 4096;
    private final long[] set = new long[MAX_BLOCKIDS / 64];

    public BlockWhitelist(int ... ids) {
        for (int i : ids) {
            this.setBlock(i);
        }
    }

    public BlockWhitelist(Block ... blocks) {
        for (Block b : blocks) {
            this.setBlock(Block.func_149682_b((Block)b));
        }
    }

    private BlockWhitelist() {
    }

    private void setBlock(int i) {
        int n = i / 64;
        this.set[n] = this.set[n] | 1L << i;
        if (this.contains(9)) {
            System.out.println("Water for " + i);
        }
    }

    public boolean contains(int blockId) {
        return (this.set[blockId / 64] & 1L << blockId) != 0L;
    }

    public boolean contains(Block block) {
        return this.contains(Block.func_149682_b((Block)block));
    }

    public BlockWhitelist intersectWith(BlockWhitelist wl2) {
        BlockWhitelist res = new BlockWhitelist();
        for (int i = 0; i < res.set.length; ++i) {
            res.set[i] = this.set[i] & wl2.set[i];
        }
        return res;
    }

    public BlockWhitelist unionWith(BlockWhitelist wl2) {
        BlockWhitelist res = new BlockWhitelist();
        for (int i = 0; i < res.set.length; ++i) {
            res.set[i] = this.set[i] | wl2.set[i];
        }
        return res;
    }

    public BlockWhitelist invert() {
        BlockWhitelist res = new BlockWhitelist();
        for (int i = 0; i < res.set.length; ++i) {
            res.set[i] = this.set[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return res;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.set);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockWhitelist other = (BlockWhitelist)obj;
        return Arrays.equals(this.set, other.set);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BlockWhitelist [");
        boolean needsComma = false;
        for (int i = 0; i < MAX_BLOCKIDS; ++i) {
            if (!this.contains(i)) continue;
            if (needsComma) {
                builder.append(", ");
            } else {
                needsComma = true;
            }
            builder.append(Block.func_149729_e((int)i).func_149732_F());
            builder.append(" (");
            builder.append(i);
            builder.append(")");
        }
        builder.append("]");
        return builder.toString();
    }
}

