/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai;

import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.BlockItemFilter;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class ColoredBlockItemFilter
extends BlockItemFilter {
    public static final Block[] COLORABLE_BLOCKS = new Block[]{Blocks.field_150325_L, Blocks.field_150406_ce, Blocks.field_150399_cn, Blocks.field_150397_co, Blocks.field_150404_cg};
    private final int colorMeta;
    public static final String[] COLORS = new String[]{"White", "Orange", "Magenta", "LightBlue", "Yellow", "Lime", "Pink", "Gray", "LightGray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};

    public ColoredBlockItemFilter(Block matched, String color) {
        this(matched, ColoredBlockItemFilter.colorFromString(color));
    }

    private static int colorFromString(String color) {
        String safeColor = color.replaceAll("[-_]", "");
        for (int i = 0; i < COLORS.length; ++i) {
            if (!COLORS[i].equalsIgnoreCase(safeColor)) continue;
            return i;
        }
        System.out.println("Did not understand color: " + color);
        return 0;
    }

    public ColoredBlockItemFilter(Block matched, int color) {
        super(matched);
        this.colorMeta = color;
        if (!AIHelper.blockIsOneOf(matched, COLORABLE_BLOCKS)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected boolean matchesItem(ItemStack itemStack, ItemBlock item) {
        return super.matchesItem(itemStack, item) && itemStack.func_77960_j() == this.colorMeta;
    }

    @Override
    public String toString() {
        return "ColoredBlockItemFilter [colorMeta=" + this.colorMeta + ", " + super.toString() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.colorMeta;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColoredBlockItemFilter other = (ColoredBlockItemFilter)obj;
        return this.colorMeta == other.colorMeta;
    }

    @Override
    public String getDescription() {
        return COLORS[this.colorMeta] + " " + super.getDescription();
    }
}

