/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.command;

import com.google.common.base.Function;
import java.util.List;
import net.famzangl.minecraft.minebot.ai.command.CommandRegistry;
import net.famzangl.minecraft.minebot.ai.commands.CommandBuildWay;
import net.famzangl.minecraft.minebot.ai.commands.CommandEat;
import net.famzangl.minecraft.minebot.ai.commands.CommandEnchant;
import net.famzangl.minecraft.minebot.ai.commands.CommandFeed;
import net.famzangl.minecraft.minebot.ai.commands.CommandFish;
import net.famzangl.minecraft.minebot.ai.commands.CommandGet;
import net.famzangl.minecraft.minebot.ai.commands.CommandGetWood;
import net.famzangl.minecraft.minebot.ai.commands.CommandHelp;
import net.famzangl.minecraft.minebot.ai.commands.CommandKill;
import net.famzangl.minecraft.minebot.ai.commands.CommandMine;
import net.famzangl.minecraft.minebot.ai.commands.CommandPause;
import net.famzangl.minecraft.minebot.ai.commands.CommandPlant;
import net.famzangl.minecraft.minebot.ai.commands.CommandRespawn;
import net.famzangl.minecraft.minebot.ai.commands.CommandRun;
import net.famzangl.minecraft.minebot.ai.commands.CommandShear;
import net.famzangl.minecraft.minebot.ai.commands.CommandSit;
import net.famzangl.minecraft.minebot.ai.commands.CommandStop;
import net.famzangl.minecraft.minebot.ai.commands.CommandStore;
import net.famzangl.minecraft.minebot.ai.commands.CommandTint;
import net.famzangl.minecraft.minebot.ai.commands.CommandTunnel;
import net.famzangl.minecraft.minebot.ai.commands.CommandUngrab;
import net.famzangl.minecraft.minebot.ai.scripting.CommandJs;
import net.famzangl.minecraft.minebot.build.commands.CommandBuild;
import net.famzangl.minecraft.minebot.build.commands.CommandClearArea;
import net.famzangl.minecraft.minebot.build.commands.CommandCount;
import net.famzangl.minecraft.minebot.build.commands.CommandListBuilds;
import net.famzangl.minecraft.minebot.build.commands.CommandMove;
import net.famzangl.minecraft.minebot.build.commands.CommandReset;
import net.famzangl.minecraft.minebot.build.commands.CommandReverse;
import net.famzangl.minecraft.minebot.build.commands.CommandScheduleBuild;
import net.famzangl.minecraft.minebot.build.commands.CommandSetPos;
import net.famzangl.minecraft.minebot.build.commands.CommandStepNext;
import net.famzangl.minecraft.minebot.build.commands.CommandStepPlace;
import net.famzangl.minecraft.minebot.build.commands.CommandStepWalk;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class AIChatController {
    private static final CommandRegistry registry = new CommandRegistry();
    private static final int PER_PAGE = 8;

    private AIChatController() {
    }

    private static void registerCommand(Class<?> commandClass) {
        registry.register(commandClass);
    }

    public static void addChatLine(String message) {
        AIChatController.addToChat("[Minebot] " + message);
    }

    public static CommandRegistry getRegistry() {
        return registry;
    }

    private static void addToChat(String string) {
        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(string));
    }

    public static <T> void addToChatPaged(String title, int page, List<T> data, Function<T, String> convert) {
        AIChatController.addChatLine(title + " " + page + " / " + (int)Math.ceil((float)data.size() / 8.0f));
        for (int i = Math.max(0, page - 1) * 8; i < Math.min(page * 8, data.size()); ++i) {
            String line = (String)convert.apply(data.get(i));
            AIChatController.addChatLine(line);
        }
    }

    static {
        AIChatController.registerCommand(CommandHelp.class);
        AIChatController.registerCommand(CommandMine.class);
        AIChatController.registerCommand(CommandTunnel.class);
        AIChatController.registerCommand(CommandStop.class);
        AIChatController.registerCommand(CommandUngrab.class);
        AIChatController.registerCommand(CommandRun.class);
        AIChatController.registerCommand(CommandJs.class);
        AIChatController.registerCommand(CommandPlant.class);
        AIChatController.registerCommand(CommandGetWood.class);
        AIChatController.registerCommand(CommandTint.class);
        AIChatController.registerCommand(CommandBuildWay.class);
        AIChatController.registerCommand(CommandShear.class);
        AIChatController.registerCommand(CommandPause.class);
        AIChatController.registerCommand(CommandStore.class);
        AIChatController.registerCommand(CommandEnchant.class);
        AIChatController.registerCommand(CommandEat.class);
        AIChatController.registerCommand(CommandRespawn.class);
        AIChatController.registerCommand(CommandGet.class);
        AIChatController.registerCommand(CommandKill.class);
        AIChatController.registerCommand(CommandFish.class);
        AIChatController.registerCommand(CommandSit.class);
        AIChatController.registerCommand(CommandFeed.class);
        AIChatController.registerCommand(CommandBuild.class);
        AIChatController.registerCommand(CommandClearArea.class);
        AIChatController.registerCommand(CommandReset.class);
        AIChatController.registerCommand(CommandScheduleBuild.class);
        AIChatController.registerCommand(CommandSetPos.class);
        AIChatController.registerCommand(CommandStepNext.class);
        AIChatController.registerCommand(CommandStepPlace.class);
        AIChatController.registerCommand(CommandStepWalk.class);
        AIChatController.registerCommand(CommandListBuilds.class);
        AIChatController.registerCommand(CommandReverse.class);
        AIChatController.registerCommand(CommandMove.class);
        AIChatController.registerCommand(CommandCount.class);
    }
}

