/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.command;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.command.AICommand;
import net.famzangl.minecraft.minebot.ai.command.AICommandInvocation;
import net.famzangl.minecraft.minebot.ai.command.AICommandParameter;
import net.famzangl.minecraft.minebot.ai.command.AIHelperBuilder;
import net.famzangl.minecraft.minebot.ai.command.ArgumentDefinition;
import net.famzangl.minecraft.minebot.ai.command.BlockNameBuilder;
import net.famzangl.minecraft.minebot.ai.command.ColorNameBuilder;
import net.famzangl.minecraft.minebot.ai.command.CommandEvaluationException;
import net.famzangl.minecraft.minebot.ai.command.CommandNameBuilder;
import net.famzangl.minecraft.minebot.ai.command.EnumNameBuilder;
import net.famzangl.minecraft.minebot.ai.command.FileNameBuilder;
import net.famzangl.minecraft.minebot.ai.command.FixedNameBuilder;
import net.famzangl.minecraft.minebot.ai.command.NumberNameBuilder;
import net.famzangl.minecraft.minebot.ai.command.OptionalParameterBuilder;
import net.famzangl.minecraft.minebot.ai.command.ParameterBuilder;
import net.famzangl.minecraft.minebot.ai.command.PositionNameBuilder;
import net.famzangl.minecraft.minebot.ai.command.SafeStrategyRule;
import net.famzangl.minecraft.minebot.ai.command.StringNameBuilder;
import net.famzangl.minecraft.minebot.ai.strategy.AIStrategy;

public class CommandDefinition {
    private final ArrayList<ArgumentDefinition> arguments;
    private final ArrayList<Integer> parameterStarts;
    private final Method method;
    private final ArrayList<ParameterBuilder> builders;

    private CommandDefinition(Method m, ArrayList<ParameterBuilder> builders, ArrayList<ArgumentDefinition> arguments, ArrayList<Integer> parameterStarts) {
        this.method = m;
        this.builders = builders;
        this.arguments = arguments;
        this.parameterStarts = parameterStarts;
    }

    private static ParameterBuilder getParameter(Method m, Class<?>[] types, Annotation[][] parameterAnnotations, int parameter) {
        ParameterBuilder b;
        if (types[parameter] == AIHelper.class) {
            b = new AIHelperBuilder(null);
        } else {
            AICommandParameter annot = CommandDefinition.findParameterAnnotation(m, parameterAnnotations[parameter]);
            switch (annot.type()) {
                case BLOCK_NAME: {
                    b = new BlockNameBuilder(annot);
                    break;
                }
                case FIXED: {
                    b = new FixedNameBuilder(annot);
                    break;
                }
                case NUMBER: {
                    b = new NumberNameBuilder(annot);
                    break;
                }
                case COMMAND: {
                    b = new CommandNameBuilder(annot);
                    break;
                }
                case COLOR: {
                    b = new ColorNameBuilder(annot);
                    break;
                }
                case ENUM: {
                    b = new EnumNameBuilder(annot, types[parameter]);
                    break;
                }
                case FILE: {
                    b = new FileNameBuilder(annot);
                    break;
                }
                case POSITION: {
                    b = new PositionNameBuilder(annot);
                    break;
                }
                case STRING: {
                    b = new StringNameBuilder(annot);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type: " + (Object)((Object)annot.type()));
                }
            }
        }
        return b;
    }

    public static ArrayList<CommandDefinition> getDefinitions(Method m) {
        ArrayList<CommandDefinition> list = new ArrayList<CommandDefinition>();
        Class<?>[] types = m.getParameterTypes();
        Annotation[][] parameterAnnotations = m.getParameterAnnotations();
        ArrayList<ParameterBuilder> builders = new ArrayList<ParameterBuilder>();
        ArrayList<ArgumentDefinition> arguments = new ArrayList<ArgumentDefinition>();
        ArrayList<Integer> parameterStarts = new ArrayList<Integer>();
        CommandDefinition.addParametersFromTo(list, m, types, parameterAnnotations, builders, arguments, parameterStarts, 0);
        return list;
    }

    private static void addParametersFromTo(ArrayList<CommandDefinition> list, Method m, Class<?>[] types, Annotation[][] parameterAnnotations, ArrayList<ParameterBuilder> builders, ArrayList<ArgumentDefinition> arguments, ArrayList<Integer> parameterStarts, int fromIndex) {
        if (fromIndex >= types.length) {
            parameterStarts.add(arguments.size());
            list.add(new CommandDefinition(m, builders, arguments, parameterStarts));
            return;
        }
        ParameterBuilder nextBuilder = CommandDefinition.getParameter(m, types, parameterAnnotations, fromIndex);
        if (nextBuilder.isOptional()) {
            ArrayList<ParameterBuilder> builders2 = new ArrayList<ParameterBuilder>(builders);
            ArrayList<ArgumentDefinition> arguments2 = new ArrayList<ArgumentDefinition>(arguments);
            ArrayList<Integer> parameterStarts2 = new ArrayList<Integer>(parameterStarts);
            CommandDefinition.addParameterBuilder(new OptionalParameterBuilder(CommandDefinition.findParameterAnnotation(m, parameterAnnotations[fromIndex])), builders2, arguments2, parameterStarts2);
            CommandDefinition.addParametersFromTo(list, m, types, parameterAnnotations, builders2, arguments2, parameterStarts2, fromIndex + 1);
        }
        CommandDefinition.addParameterBuilder(nextBuilder, builders, arguments, parameterStarts);
        CommandDefinition.addParametersFromTo(list, m, types, parameterAnnotations, builders, arguments, parameterStarts, fromIndex + 1);
    }

    private static void addParameterBuilder(ParameterBuilder nextBuilder, ArrayList<ParameterBuilder> builders, ArrayList<ArgumentDefinition> arguments, ArrayList<Integer> parameterStarts) {
        parameterStarts.add(arguments.size());
        nextBuilder.addArguments(arguments);
        builders.add(nextBuilder);
    }

    private static AICommandParameter findParameterAnnotation(Method m, Annotation[] annotations) {
        for (Annotation a : annotations) {
            if (!(a instanceof AICommandParameter)) continue;
            return (AICommandParameter)a;
        }
        throw new IllegalArgumentException("Could not find parameter annotation for " + m.getName() + " of  class " + m.getDeclaringClass().getSimpleName());
    }

    public boolean couldEvaluateAgainst(String[] arguments2) {
        if (arguments2.length != this.arguments.size()) {
            return false;
        }
        return this.couldEvaluateStartingWith(arguments2);
    }

    public boolean couldEvaluateStartingWith(String[] arguments2) {
        if (arguments2.length > this.arguments.size()) {
            return false;
        }
        for (int i = 0; i < arguments2.length; ++i) {
            if (this.arguments.get(i).couldEvaluateAgainst(arguments2[i])) continue;
            return false;
        }
        return true;
    }

    public AIStrategy evaluate(AIHelper helper, String[] args) {
        Object[] params = new Object[this.builders.size()];
        for (int parameter = 0; parameter < this.builders.size(); ++parameter) {
            String[] argsPart = Arrays.copyOfRange(args, (int)this.parameterStarts.get(parameter), (int)this.parameterStarts.get(parameter + 1));
            params[parameter] = this.builders.get(parameter).getParameter(helper, argsPart);
        }
        try {
            Object result = this.method.invoke(null, params);
            if (result instanceof AIStrategy) {
                return (AIStrategy)result;
            }
            return null;
        }
        catch (IllegalAccessException e) {
            this.doThrow(e);
        }
        catch (IllegalArgumentException e) {
            this.doThrow(e);
        }
        catch (InvocationTargetException e) {
            Throwable exception = e.getTargetException();
            this.doThrow(exception);
        }
        return null;
    }

    private void doThrow(Throwable exception) {
        exception.printStackTrace();
        throw exception instanceof CommandEvaluationException ? (CommandEvaluationException)exception : new CommandEvaluationException("Unexpected error while evaluating.", exception);
    }

    public ArrayList<ArgumentDefinition> getArguments() {
        return this.arguments;
    }

    private AICommand getCommandAnnotation() {
        return this.method.getDeclaringClass().getAnnotation(AICommand.class);
    }

    public String getHelpText() {
        return this.getCommandAnnotation().helpText();
    }

    public String getCommandName() {
        return this.getCommandAnnotation().name();
    }

    public SafeStrategyRule getSafeStrategyRule() {
        return this.method.getAnnotation(AICommandInvocation.class).safeRule();
    }
}

