/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.command;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.command.AIChatController;
import net.famzangl.minecraft.minebot.ai.command.AICommand;
import net.famzangl.minecraft.minebot.ai.command.AICommandInvocation;
import net.famzangl.minecraft.minebot.ai.command.ArgumentDefinition;
import net.famzangl.minecraft.minebot.ai.command.CommandDefinition;
import net.famzangl.minecraft.minebot.ai.command.CommandEvaluationException;
import net.famzangl.minecraft.minebot.ai.command.IAIControllable;
import net.famzangl.minecraft.minebot.ai.command.SafeStrategyRule;
import net.famzangl.minecraft.minebot.ai.command.UnknownCommandException;
import net.famzangl.minecraft.minebot.ai.strategy.AIStrategy;
import net.famzangl.minecraft.minebot.ai.strategy.AbortOnDeathStrategy;
import net.famzangl.minecraft.minebot.ai.strategy.CreeperComesActionStrategy;
import net.famzangl.minecraft.minebot.ai.strategy.DamageTakenStrategy;
import net.famzangl.minecraft.minebot.ai.strategy.DoNotSuffocateStrategy;
import net.famzangl.minecraft.minebot.ai.strategy.PlayerComesActionStrategy;
import net.famzangl.minecraft.minebot.ai.strategy.StackStrategy;
import net.famzangl.minecraft.minebot.ai.strategy.StrategyStack;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraftforge.client.ClientCommandHandler;

public class CommandRegistry {
    private final Hashtable<String, List<CommandDefinition>> commandTable = new Hashtable();
    private IAIControllable controlled;

    public void register(Class<?> commandClass) {
        this.checkCommandClass(commandClass);
        String name = commandClass.getAnnotation(AICommand.class).name();
        List<CommandDefinition> list = this.commandTable.get(name);
        if (list == null) {
            list = new ArrayList<CommandDefinition>();
            this.commandTable.put(name, list);
            this.addCommandHandler(name);
        }
        this.getCommandsForClass(commandClass, list);
    }

    private void addCommandHandler(String name) {
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandHandler(name));
        System.out.println("Command " + name + " registered.");
    }

    private void checkCommandClass(Class<?> commandClass) {
        if (!commandClass.isAnnotationPresent(AICommand.class)) {
            throw new IllegalArgumentException("AICommand is not set for this class.");
        }
    }

    public AIStrategy evaluateCommandWithSaferule(AIHelper helper, String commandID, String[] arguments) throws UnknownCommandException {
        CommandDefinition evaluateableCommand = this.getEvaluatebale(commandID, arguments);
        AIStrategy strategy = evaluateableCommand.evaluate(helper, arguments);
        SafeStrategyRule safeRule = evaluateableCommand.getSafeStrategyRule();
        if (safeRule != SafeStrategyRule.NONE && strategy != null) {
            strategy = this.makeSafe(strategy, safeRule);
        }
        return strategy;
    }

    public AIStrategy evaluateCommand(AIHelper helper, String commandID, String[] arguments) throws UnknownCommandException {
        CommandDefinition evaluateableCommand = this.getEvaluatebale(commandID, arguments);
        return evaluateableCommand.evaluate(helper, arguments);
    }

    private CommandDefinition getEvaluatebale(String commandID, String[] arguments) throws UnknownCommandException {
        List<CommandDefinition> commands = this.getCommands(commandID);
        ArrayList<CommandDefinition> evaluateable = new ArrayList<CommandDefinition>();
        for (CommandDefinition c : commands) {
            if (!c.couldEvaluateAgainst(arguments)) continue;
            evaluateable.add(c);
        }
        if (evaluateable.size() != 1) {
            throw new UnknownCommandException(evaluateable);
        }
        CommandDefinition evaluateableCommand = (CommandDefinition)evaluateable.get(0);
        return evaluateableCommand;
    }

    private AIStrategy makeSafe(AIStrategy strategy, SafeStrategyRule safeRule) {
        StrategyStack stack = new StrategyStack();
        stack.addStrategy(new AbortOnDeathStrategy());
        if (safeRule == SafeStrategyRule.DEFEND_MINING) {
            stack.addStrategy(new DoNotSuffocateStrategy());
        }
        stack.addStrategy(new DamageTakenStrategy());
        stack.addStrategy(new PlayerComesActionStrategy());
        stack.addStrategy(new CreeperComesActionStrategy());
        stack.addStrategy(strategy);
        return new StackStrategy(stack);
    }

    public List<String> tabCompletion(AIHelper helper, String commandID, String[] currentArgs) {
        List<CommandDefinition> commands = this.getCommands(commandID);
        HashSet<String> suggestions = new HashSet<String>();
        String[] fixedArgs = Arrays.copyOf(currentArgs, currentArgs.length - 1);
        for (CommandDefinition c : commands) {
            ArrayList<ArgumentDefinition> args = c.getArguments();
            if (!c.couldEvaluateStartingWith(fixedArgs) || args.size() <= fixedArgs.length) continue;
            ArgumentDefinition lastArg = c.getArguments().get(currentArgs.length - 1);
            lastArg.getTabCompleteOptions(currentArgs[currentArgs.length - 1], suggestions);
        }
        ArrayList<String> asList = new ArrayList<String>(suggestions);
        Collections.sort(asList);
        return asList;
    }

    private List<CommandDefinition> getCommands(String commandID) {
        List<CommandDefinition> commands = this.commandTable.get(commandID);
        if (commands == null) {
            commands = Collections.emptyList();
        }
        return commands;
    }

    private void getCommandsForClass(Class<?> commandClass, List<CommandDefinition> commands) {
        for (Method m : commandClass.getMethods()) {
            if (!Modifier.isStatic(m.getModifiers()) || !m.isAnnotationPresent(AICommandInvocation.class)) continue;
            commands.addAll(this.getCommandsForMethod(m));
        }
    }

    private ArrayList<CommandDefinition> getCommandsForMethod(Method m) {
        return CommandDefinition.getDefinitions(m);
    }

    public List<CommandDefinition> getAllCommands() {
        ArrayList<CommandDefinition> defs = new ArrayList<CommandDefinition>();
        for (List<CommandDefinition> list : this.commandTable.values()) {
            defs.addAll(list);
        }
        return defs;
    }

    public IAIControllable getControlled() {
        return this.controlled;
    }

    public void setControlled(IAIControllable controlled) {
        this.controlled = controlled;
    }

    private final class CommandHandler
    extends CommandBase {
        private final String name;

        public CommandHandler(String name) {
            this.name = name;
        }

        public void func_71515_b(ICommandSender sender, String[] args) {
            if (CommandRegistry.this.controlled == null) {
                AIChatController.addChatLine("ERROR: No controller started.");
            }
            try {
                AIStrategy strategy = CommandRegistry.this.evaluateCommandWithSaferule(CommandRegistry.this.controlled.getAiHelper(), this.name, args);
                if (strategy != null) {
                    CommandRegistry.this.controlled.requestUseStrategy(strategy);
                }
            }
            catch (UnknownCommandException e) {
                if (e.getEvaluateable().size() > 0) {
                    AIChatController.addChatLine("ERROR: More than 1 command matches your command line.");
                } else {
                    AIChatController.addChatLine("ERROR: No command:" + this.combine(args) + ".");
                }
            }
            catch (CommandEvaluationException e) {
                AIChatController.addChatLine("ERROR while evaluating: " + e.getMessage());
            }
            catch (Throwable e) {
                e.printStackTrace();
                AIChatController.addChatLine("ERROR: Could not evaluate. Please report.");
            }
        }

        private String combine(String[] args) {
            StringBuilder b = new StringBuilder();
            for (String a : args) {
                b.append(" ");
                b.append(a);
            }
            return b.toString();
        }

        public String func_71518_a(ICommandSender var1) {
            return "/" + this.name + " ...";
        }

        public String func_71517_b() {
            return this.name;
        }

        public List<String> func_71516_a(ICommandSender par1iCommandSender, String[] par2ArrayOfStr) {
            if (CommandRegistry.this.controlled == null) {
                return Collections.emptyList();
            }
            return CommandRegistry.this.tabCompletion(CommandRegistry.this.controlled.getAiHelper(), this.name, par2ArrayOfStr);
        }

        public int func_82362_a() {
            return 0;
        }
    }
}

