/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.commands;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.command.AIChatController;
import net.famzangl.minecraft.minebot.ai.command.AICommand;
import net.famzangl.minecraft.minebot.ai.command.AICommandInvocation;
import net.famzangl.minecraft.minebot.ai.command.AICommandParameter;
import net.famzangl.minecraft.minebot.ai.command.ArgumentDefinition;
import net.famzangl.minecraft.minebot.ai.command.CommandDefinition;
import net.famzangl.minecraft.minebot.ai.command.FixedNameBuilder;
import net.famzangl.minecraft.minebot.ai.command.ParameterType;
import net.famzangl.minecraft.minebot.ai.strategy.AIStrategy;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

@AICommand(helpText="Gives help about the minebot commands.\nIt can display an index of commands or can give help to a specific command.", name="minebot")
public final class CommandHelp {
    @AICommandInvocation
    public static AIStrategy run(AIHelper helper, @AICommandParameter(type=ParameterType.FIXED, fixedName="help", description="") String nameArg) {
        return CommandHelp.run(helper, nameArg, 1);
    }

    @AICommandInvocation
    public static AIStrategy run(AIHelper helper, @AICommandParameter(type=ParameterType.FIXED, fixedName="help", description="") String nameArg, @AICommandParameter(type=ParameterType.NUMBER, description="help page") int page) {
        ArrayList<CommandDefinition> commands = new ArrayList<CommandDefinition>(AIChatController.getRegistry().getAllCommands());
        Collections.sort(commands, new CommandComperator());
        AIChatController.addToChatPaged("Help", page, commands, new CommandToTextConverter());
        return null;
    }

    @AICommandInvocation
    public static AIStrategy run(AIHelper helper, @AICommandParameter(type=ParameterType.FIXED, fixedName="help", description="") String nameArg, @AICommandParameter(type=ParameterType.COMMAND, description="command help") String commandName) {
        boolean found = false;
        EntityClientPlayerMP player = helper.getMinecraft().field_71439_g;
        for (CommandDefinition command : AIChatController.getRegistry().getAllCommands()) {
            ArrayList<ArgumentDefinition> args = command.getArguments();
            if (args.get(0).couldEvaluateAgainst(commandName)) {
                if (found) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(""));
                }
                CommandHelp.printHelp(player, command);
            }
            found = true;
        }
        if (!found) {
            AIChatController.addChatLine("Command could not be found: " + commandName);
        }
        return null;
    }

    private static void printHelp(EntityClientPlayerMP player, CommandDefinition command) {
        CommandToTextConverter conv = new CommandToTextConverter();
        ChatComponentText headline = new ChatComponentText(conv.apply(command));
        headline.func_150256_b().func_150227_a(Boolean.valueOf(true));
        player.func_145747_a((IChatComponent)headline);
        for (String line : command.getHelpText().split("\n")) {
            ChatComponentText text = new ChatComponentText(line);
            text.func_150256_b().func_150217_b(Boolean.valueOf(true));
            player.func_145747_a((IChatComponent)text);
        }
        for (ArgumentDefinition arg : command.getArguments()) {
            String[] help;
            for (String text : help = arg.getDescriptionString().split("\n")) {
                player.func_145747_a((IChatComponent)new ChatComponentText("   " + text));
            }
        }
    }

    private static final class CommandComperator
    implements Comparator<CommandDefinition> {
        private CommandComperator() {
        }

        @Override
        public int compare(CommandDefinition o1, CommandDefinition o2) {
            int res = o1.getCommandName().compareTo(o2.getCommandName());
            if (res != 0) {
                return res;
            }
            ArgumentDefinition a1 = o1.getArguments().get(0);
            ArgumentDefinition a2 = o2.getArguments().get(0);
            if (a1 instanceof FixedNameBuilder.FixedArgumentDefinition && a2 instanceof FixedNameBuilder.FixedArgumentDefinition) {
                String n1 = ((FixedNameBuilder.FixedArgumentDefinition)a1).getFixedName();
                String n2 = ((FixedNameBuilder.FixedArgumentDefinition)a2).getFixedName();
                return n1.compareTo(n2);
            }
            return 0;
        }
    }

    private static final class CommandToTextConverter
    implements Function<CommandDefinition, String> {
        private CommandToTextConverter() {
        }

        public String apply(CommandDefinition command) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("/");
            stringBuilder.append(command.getCommandName());
            for (ArgumentDefinition arg : command.getArguments()) {
                stringBuilder.append(" ");
                stringBuilder.append(arg.getDescriptionType());
            }
            return stringBuilder.toString();
        }
    }
}

