/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.enchanting;

import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.enchanting.ClickOnEnchantmentTable;
import net.famzangl.minecraft.minebot.ai.enchanting.CloseScreenTask;
import net.famzangl.minecraft.minebot.ai.enchanting.FaceAnyMobTask;
import net.famzangl.minecraft.minebot.ai.enchanting.FaceBlockOfTypeTask;
import net.famzangl.minecraft.minebot.ai.enchanting.KillAnyMobTask;
import net.famzangl.minecraft.minebot.ai.enchanting.PutItemInTableTask;
import net.famzangl.minecraft.minebot.ai.enchanting.SelectEnchantmentTask;
import net.famzangl.minecraft.minebot.ai.enchanting.TakeEnchantedItemTask;
import net.famzangl.minecraft.minebot.ai.strategy.TaskStrategy;
import net.minecraft.client.gui.GuiEnchantment;

public class EnchantStrategy
extends TaskStrategy {
    private final int level;

    public EnchantStrategy() {
        this(30);
    }

    public EnchantStrategy(int level) {
        this.level = level;
    }

    @Override
    public void searchTasks(AIHelper helper) {
        if (this.hasLevelsToEnchant(helper)) {
            if (this.enchantmentTableOpened(helper)) {
                this.addTask(new PutItemInTableTask());
                this.addTask(new SelectEnchantmentTask());
            } else {
                this.addTask(new FaceBlockOfTypeTask());
                this.addTask(new ClickOnEnchantmentTable());
            }
        } else if (this.enchantmentTableOpened(helper)) {
            this.addTask(new TakeEnchantedItemTask());
            this.addTask(new CloseScreenTask());
        } else {
            this.addTask(new FaceAnyMobTask());
            this.addTask(new KillAnyMobTask());
        }
    }

    private boolean hasLevelsToEnchant(AIHelper helper) {
        return helper.getMinecraft().field_71439_g.field_71068_ca >= this.level;
    }

    private boolean enchantmentTableOpened(AIHelper helper) {
        return helper.getMinecraft().field_71462_r instanceof GuiEnchantment;
    }

    @Override
    public String getDescription(AIHelper helper) {
        return "Enchanting for level " + this.level;
    }
}

