/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.enchanting;

import java.lang.reflect.Field;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.strategy.TaskOperations;
import net.famzangl.minecraft.minebot.ai.task.AITask;
import net.famzangl.minecraft.minebot.ai.task.error.StringTaskError;
import net.minecraft.client.gui.GuiEnchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerEnchantment;

public class SelectEnchantmentTask
extends AITask {
    private static final int E_SLOT = 2;

    @Override
    public boolean isFinished(AIHelper h) {
        if (!(h.getMinecraft().field_71462_r instanceof GuiEnchantment)) {
            return false;
        }
        GuiEnchantment screen = (GuiEnchantment)h.getMinecraft().field_71462_r;
        return screen.field_147002_h.func_75139_a(0).func_75216_d() && screen.field_147002_h.func_75139_a(0).func_75211_c().func_77948_v();
    }

    @Override
    public void runTick(AIHelper h, TaskOperations o) {
        if (!(h.getMinecraft().field_71462_r instanceof GuiEnchantment)) {
            System.out.println("Screen not opened.");
            o.desync(new StringTaskError("Enchantment screen is not open."));
            return;
        }
        GuiEnchantment screen = (GuiEnchantment)h.getMinecraft().field_71462_r;
        if (!screen.field_147002_h.func_75139_a(0).func_75216_d()) {
            System.out.println("No stack in slot.");
            o.desync(new StringTaskError("No stack in enchantment table."));
            return;
        }
        if (screen.field_147002_h.func_75139_a(0).func_75211_c().func_77948_v()) {
            System.out.println("Already enchanted.");
            return;
        }
        try {
            Field field = GuiEnchantment.class.getDeclaredField("field_147075_G");
            field.setAccessible(true);
            ContainerEnchantment c = (ContainerEnchantment)field.get(screen);
            if (c.field_75167_g[2] == 0) {
                System.out.println("No enchantment levels computed yet.");
                return;
            }
            if (h.getMinecraft().field_71439_g.field_71068_ca < c.field_75167_g[2]) {
                System.out.println("Abort enchantment, not enough levels.");
                return;
            }
            if (c.func_75140_a((EntityPlayer)h.getMinecraft().field_71439_g, 2)) {
                h.getMinecraft().field_71442_b.func_78756_a(c.field_75152_c, 2);
            }
            System.out.println("Sent enchant request package.");
            return;
        }
        catch (Throwable e) {
            e.printStackTrace();
            o.desync(new StringTaskError("Some error... :-("));
            return;
        }
    }
}

