/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.path;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.BlockItemFilter;
import net.famzangl.minecraft.minebot.ai.BlockWhitelist;
import net.famzangl.minecraft.minebot.ai.path.AlongTrackPathFinder;
import net.famzangl.minecraft.minebot.ai.task.AITask;
import net.famzangl.minecraft.minebot.ai.task.BlockSide;
import net.famzangl.minecraft.minebot.ai.task.DestroyInRangeTask;
import net.famzangl.minecraft.minebot.ai.task.GetOnHotBarTask;
import net.famzangl.minecraft.minebot.ai.task.PlaceBlockTask;
import net.famzangl.minecraft.minebot.ai.task.PlaceTorchSomewhereTask;
import net.famzangl.minecraft.minebot.build.WalkTowardsTask;
import net.famzangl.minecraft.minebot.build.blockbuild.BlockBuildTask;
import net.famzangl.minecraft.minebot.build.blockbuild.BuildHalfslabTask;
import net.famzangl.minecraft.minebot.build.blockbuild.SlabFilter;
import net.famzangl.minecraft.minebot.build.blockbuild.SlabType;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.util.ForgeDirection;

public class BuildWayPathfinder
extends AlongTrackPathFinder {
    private static final SlabType FLOOR = SlabType.COBBLESTONE;
    private static final Block BRIDGE_SIDE = Blocks.field_150347_e;
    private static final Block BRIDGE_WALL = Blocks.field_150463_bK;
    private final int width = 2;
    private final ArrayList<WayPiece> wayTypes = new ArrayList();

    private BuildWayPathfinder(int dx, int dz, int cx, int cy, int cz) {
        super(dx, dz, cx, cy, cz, -1);
    }

    public BuildWayPathfinder(ForgeDirection dir, Pos pos) {
        this(dir.offsetX, dir.offsetZ, pos.x, pos.y + 1, pos.z);
    }

    private WayPiece getSuggestedWayType(int progress) {
        while (this.wayTypes.size() <= progress) {
            this.computeNextWayType();
        }
        return this.wayTypes.get(progress);
    }

    public ForgeDirection getForwardDirection() {
        return AIHelper.getDirectionForXZ(this.dx, this.dz);
    }

    @Override
    protected boolean runSearch(Pos playerPosition) {
        if (!this.addContinuingTask(playerPosition)) {
            return super.runSearch(playerPosition);
        }
        return true;
    }

    private void computeNextWayType() {
        NormalWayType base;
        int i = this.wayTypes.size();
        WayPiece type = base = new NormalWayType(i);
        type = base.needsBridge() ? new BridgeWayType(i) : (base.needsTunnel() ? new TunnelWayType(i) : new FlatlandWayType(i));
        type.placeTorch = i % 8 == 0;
        this.wayTypes.add(type);
    }

    @Override
    protected void addTasksForTarget(Pos currentPos) {
        int currentStep = this.getStepNumber(currentPos.x, currentPos.z);
        if (currentPos.y == this.cy - 1 && !this.getSuggestedWayType(currentStep).isDone()) {
            this.getSuggestedWayType(currentStep).addConstructionTasksFromInner();
        }
    }

    public boolean addContinuingTask(Pos playerPosition) {
        int currentStep;
        WayPiece next;
        System.out.println("Seatch at " + playerPosition + ", on track: " + this.isOnTrack(playerPosition.x, playerPosition.z) + ", cy= " + (this.cy - 1) + " right block: " + AIHelper.blockIsOneOf(this.helper.getBlock(playerPosition), BuildWayPathfinder.FLOOR.slabBlock));
        if (this.isOnTrack(playerPosition.x, playerPosition.z) && playerPosition.y == this.cy - 1 && AIHelper.blockIsOneOf(this.helper.getBlock(playerPosition), BuildWayPathfinder.FLOOR.slabBlock) && !(next = this.getSuggestedWayType((currentStep = this.getStepNumber(playerPosition.x, playerPosition.z)) + 1)).isDone()) {
            next.addConstructionTasksFromPrevoius(playerPosition.add(0, 1, 0));
            return true;
        }
        return false;
    }

    @Override
    protected float rateDestination(int distance, int x, int y, int z) {
        if (!this.isOnTrack(x, z)) {
            return -1.0f;
        }
        int currentStep = this.getStepNumber(x, z);
        if (y == this.cy - 1 && !this.getSuggestedWayType(currentStep).isDone()) {
            return distance;
        }
        return -1.0f;
    }

    public String toString() {
        return "BuildWayPathfinder [width=2, wayTypes=" + this.wayTypes + ", dx=" + this.dx + ", dz=" + this.dz + ", cx=" + this.cx + ", cy=" + this.cy + ", cz=" + this.cz + "]";
    }

    private class FlatlandWayType
    extends WayPiece {
        public FlatlandWayType(int stepIndex) {
            super(stepIndex);
        }

        @Override
        public void addConstructionTasks(Pos currentPos) {
            if (this.placeTorch) {
                BuildWayPathfinder.this.addTask(new GetOnHotBarTask(new BlockItemFilter(BRIDGE_SIDE)));
            }
            super.addConstructionTasks(currentPos);
        }

        @Override
        protected DestroyInRangeTask getClearAreaTask() {
            if (this.placeTorch) {
                return new DestroyInRangeTask(this.getPos(-1, -1), this.getPos(2, 2));
            }
            return super.getClearAreaTask();
        }

        @Override
        protected void addFarSideBuildTasks() {
            if (this.placeTorch) {
                this.addFarSide();
            }
            super.addFarSideBuildTasks();
            if (this.placeTorch) {
                BuildWayPathfinder.this.addTask(new PlaceTorchSomewhereTask(Collections.singletonList(this.getPos(2, 0)), ForgeDirection.DOWN));
            }
        }

        @Override
        protected void addNearSideBuildTasks() {
            if (this.placeTorch) {
                this.addNearSide();
            }
            super.addNearSideBuildTasks();
            if (this.placeTorch) {
                BuildWayPathfinder.this.addTask(new PlaceTorchSomewhereTask(Collections.singletonList(this.getPos(-1, 0)), ForgeDirection.DOWN));
            }
        }
    }

    private class TunnelWayType
    extends WayPiece {
        public TunnelWayType(int stepIndex) {
            super(stepIndex);
        }

        @Override
        protected void addNearSideBuildTasks() {
            super.addNearSideBuildTasks();
            if (this.placeTorch) {
                BuildWayPathfinder.this.addTask(new PlaceTorchSomewhereTask(Arrays.asList(this.getPos(0, 1), this.getPos(0, 0), this.getPos(-1, 1)), BuildWayPathfinder.this.getForwardDirection().getRotation(ForgeDirection.UP), ForgeDirection.DOWN));
            }
        }

        @Override
        protected void addFarSideBuildTasks() {
            super.addFarSideBuildTasks();
            if (this.placeTorch) {
                BuildWayPathfinder.this.addTask(new PlaceTorchSomewhereTask(Arrays.asList(this.getPos(1, 1), this.getPos(1, 0), this.getPos(2, 1)), BuildWayPathfinder.this.getForwardDirection().getRotation(ForgeDirection.DOWN), ForgeDirection.DOWN));
            }
        }
    }

    private class BridgeWayType
    extends WayPiece {
        public BridgeWayType(int stepIndex) {
            super(stepIndex);
        }

        @Override
        public void addConstructionTasks(Pos currentPos) {
            BuildWayPathfinder.this.addTask(new GetOnHotBarTask(new BlockItemFilter(BRIDGE_WALL)));
            BuildWayPathfinder.this.addTask(new GetOnHotBarTask(new BlockItemFilter(BRIDGE_SIDE)));
            super.addConstructionTasks(currentPos);
        }

        @Override
        protected void addFarSideBuildTasks() {
            this.addFarSide();
            super.addFarSideBuildTasks();
            BuildWayPathfinder.this.addTask(new PlaceBlockTask(this.getPos(2, -1), ForgeDirection.UP, BRIDGE_WALL));
            if (this.placeTorch) {
                BuildWayPathfinder.this.addTask(new PlaceTorchSomewhereTask(Collections.singletonList(this.getPos(2, 1)), ForgeDirection.DOWN));
            }
        }

        @Override
        protected void addNearSideBuildTasks() {
            this.addNearSide();
            super.addNearSideBuildTasks();
            BuildWayPathfinder.this.addTask(new PlaceBlockTask(this.getPos(-1, -1), ForgeDirection.UP, BRIDGE_WALL));
            if (this.placeTorch) {
                BuildWayPathfinder.this.addTask(new PlaceTorchSomewhereTask(Collections.singletonList(this.getPos(-1, 1)), ForgeDirection.DOWN));
            }
        }

        @Override
        protected DestroyInRangeTask getClearAreaTask() {
            return new DestroyInRangeTask(this.getPos(-1, -1), this.getPos(2, 2));
        }
    }

    private class NormalWayType
    extends WayPiece {
        private final BlockWhitelist airLike;

        public NormalWayType(int stepIndex) {
            super(stepIndex);
            this.airLike = AIHelper.air.unionWith(AIHelper.walkableBlocks);
        }

        public boolean needsTunnel() {
            int covered = 0;
            for (int y = 2; y <= 3; ++y) {
                for (int u = -1; u <= 3; ++u) {
                    Block block = BuildWayPathfinder.this.helper.getBlock(this.getPos(u, y));
                    if (!AIHelper.normalBlocks.contains(block) && !AIHelper.fallingBlocks.contains(block)) continue;
                    ++covered;
                }
            }
            return covered >= 3;
        }

        public boolean needsBridge() {
            return this.isAirlike(-1, 0) && this.isAirlike(-1, -1) && this.isAirlike(-1, -2) || this.isAirlike(2, 0) && this.isAirlike(2, -1) && this.isAirlike(2, -2);
        }

        private boolean isAirlike(int u, int dy) {
            Block block = BuildWayPathfinder.this.helper.getBlock(this.getPos(u, dy));
            return this.airLike.contains(block);
        }
    }

    private abstract class WayPiece {
        protected boolean placeTorch;
        private final int stepIndex;
        private boolean done;

        public WayPiece(int stepIndex) {
            this.stepIndex = stepIndex;
        }

        protected Pos getPos(int u, int dy) {
            return new Pos(BuildWayPathfinder.this.cx + BuildWayPathfinder.this.dx * this.stepIndex + BuildWayPathfinder.this.dz * u, BuildWayPathfinder.this.cy + dy, BuildWayPathfinder.this.cz + BuildWayPathfinder.this.dz * this.stepIndex - BuildWayPathfinder.this.dx * u);
        }

        public boolean isDone() {
            return this.done;
        }

        public void addConstructionTasks(Pos currentPos) {
            BuildWayPathfinder.this.addTask(new GetOnHotBarTask(new SlabFilter(FLOOR)));
            if (this.placeTorch) {
                BuildWayPathfinder.this.addTask(new GetOnHotBarTask(new BlockItemFilter(Blocks.field_150478_aa)));
            }
            Pos first = this.getPos(0, -1);
            AITask placeTask = new BuildHalfslabTask(first, FLOOR, BlockSide.LOWER_HALF).getPlaceBlockTask(currentPos.subtract(first));
            BuildWayPathfinder.this.addTask(placeTask);
            DestroyInRangeTask clearTask = this.getClearAreaTask();
            clearTask.blacklist(first);
            BuildWayPathfinder.this.addTask(clearTask);
            for (int i = 1; i < 2; ++i) {
                Pos current = this.getPos(i, -1);
                BuildWayPathfinder.this.addTask(new BuildHalfslabTask(current, FLOOR, BlockSide.LOWER_HALF).getPlaceBlockTask(this.getPos(i - 1, 0).subtract(current)));
            }
            this.addFarSideBuildTasks();
            BuildWayPathfinder.this.addTask(new WalkTowardsTask(this.getPos(1, 0), this.getPos(0, 0)));
            this.addNearSideBuildTasks();
            this.done = true;
        }

        protected void addFarSideBuildTasks() {
            BuildWayPathfinder.this.addTask(new WalkTowardsTask(this.getPos(2, 1), this.getPos(1, 0)));
        }

        protected void addNearSideBuildTasks() {
            BuildWayPathfinder.this.addTask(new WalkTowardsTask(this.getPos(-1, 1), this.getPos(0, 0)));
        }

        protected DestroyInRangeTask getClearAreaTask() {
            return new DestroyInRangeTask(this.getPos(0, -1), this.getPos(1, 2));
        }

        public void addConstructionTasksFromInner() {
            BuildWayPathfinder.this.addTask(new DestroyInRangeTask(this.getPos(0, -1), this.getPos(0, 1)));
            this.addConstructionTasks(this.getPos(0, -1));
        }

        public void addConstructionTasksFromPrevoius(Pos current) {
            Pos floorPos = this.getPos(0, -1);
            Block floor = BuildWayPathfinder.this.helper.getBlock(floorPos);
            BuildWayPathfinder.this.addTask(new DestroyInRangeTask(floorPos, this.getPos(0, 1)));
            this.addConstructionTasks(current);
        }

        protected final void addNearSide() {
            BlockBuildTask task = new BlockBuildTask(this.getPos(-1, -1), BRIDGE_SIDE);
            BuildWayPathfinder.this.addTask(task.getPlaceBlockTask(this.getPos(1, 1).subtract(this.getPos(0, 0))));
        }

        protected final void addFarSide() {
            BlockBuildTask task = new BlockBuildTask(this.getPos(2, -1), BRIDGE_SIDE);
            BuildWayPathfinder.this.addTask(task.getPlaceBlockTask(this.getPos(-1, 1).subtract(this.getPos(0, 0))));
        }
    }
}

