/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.path;

import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.BlockItemFilter;
import net.famzangl.minecraft.minebot.ai.path.AlongTrackPathFinder;
import net.famzangl.minecraft.minebot.ai.task.MineBlockTask;
import net.famzangl.minecraft.minebot.ai.task.move.DownwardsMoveTask;
import net.famzangl.minecraft.minebot.ai.task.move.UpwardsMoveTask;
import net.famzangl.minecraft.minebot.ai.task.place.PlaceBlockAtFloorTask;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class LayRailPathFinder
extends AlongTrackPathFinder {
    public LayRailPathFinder(int dx, int dz, int cx, int cy, int cz) {
        super(dx, dz, cx, cy, cz, -1);
    }

    @Override
    protected int getNeighbour(int currentNode, int cx, int cy, int cz) {
        int res = super.getNeighbour(currentNode, cx, cy, cz);
        if (res > 0 && this.helper.isRailBlock(this.helper.getBlock(cx, cy + 1, cz))) {
            return -1;
        }
        return res;
    }

    @Override
    protected float rateDestination(int distance, int x, int y, int z) {
        if (this.isRedstoneBlockPosition(x, y, z) && !Block.func_149680_a((Block)this.helper.getBlock(x, y, z), (Block)Blocks.field_150451_bX)) {
            return distance + 2;
        }
        if (this.isOnTrack(x, z) && y == this.cy && !this.helper.isRailBlock(this.helper.getBlock(x, y, z))) {
            return distance + 5;
        }
        return -1.0f;
    }

    private boolean isRedstoneBlockPosition(int x, int y, int z) {
        return y == this.cy - 1 && this.isOnTrack(x, z) && this.placeAccRail(x, z) && this.helper.isAirBlock(x, y + 2, z);
    }

    private boolean placeAccRail(int x, int z) {
        return this.getStepNumber(x, z) % 8 == 0;
    }

    @Override
    protected void addTasksForTarget(Pos currentPos) {
        if (this.isRedstoneBlockPosition(currentPos.x, currentPos.y, currentPos.z)) {
            this.addTask(new UpwardsMoveTask(currentPos.x, currentPos.y + 1, currentPos.z, new BlockItemFilter(Blocks.field_150451_bX)));
        } else if (this.placeAccRail(currentPos.x, currentPos.z)) {
            if (!Block.func_149680_a((Block)this.helper.getBlock(currentPos.x, currentPos.y - 1, currentPos.z), (Block)Blocks.field_150451_bX) && this.helper.hasSafeSides(currentPos.x, currentPos.y - 1, currentPos.z) && this.helper.isSafeGroundBlock(currentPos.x, currentPos.y - 2, currentPos.z)) {
                this.addTask(new DownwardsMoveTask(currentPos.x, currentPos.y - 1, currentPos.z));
                this.addTask(new UpwardsMoveTask(currentPos.x, currentPos.y, currentPos.z, new BlockItemFilter(Blocks.field_150451_bX)));
            }
            this.placeRail(currentPos, Blocks.field_150318_D);
        } else {
            this.placeRail(currentPos, Blocks.field_150448_aq);
        }
    }

    private void placeRail(Pos currentPos, Block rail) {
        if (!this.helper.isAirBlock(currentPos.x, currentPos.y, currentPos.z)) {
            this.addTask(new MineBlockTask(currentPos.x, currentPos.y, currentPos.z));
        }
        this.addTask(new PlaceBlockAtFloorTask(currentPos.x, currentPos.y, currentPos.z, new BlockItemFilter(rail)));
    }

    public String toString() {
        return "LayRailPathFinder [dx=" + this.dx + ", dz=" + this.dz + ", cx=" + this.cx + ", cy=" + this.cy + ", cz=" + this.cz + "]";
    }
}

