/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.path;

import net.famzangl.minecraft.minebot.ai.path.MinePathfinder;
import net.minecraft.block.Block;
import net.minecraftforge.common.util.ForgeDirection;

public class MineBySettingsPathFinder
extends MinePathfinder {
    public MineBySettingsPathFinder(ForgeDirection preferedDirection, int preferedLayer) {
        super(preferedDirection, preferedLayer);
        this.maxDistancePoints = 0.0f;
        this.maxDistanceFactor = 0.1f;
        for (String s : this.settings.getKeys()) {
            float p;
            if (s.matches("mine_points_.*")) {
                p = this.settings.getFloat(s, 1.0f, 0.0f, 50.0f);
                this.maxDistancePoints = Math.max(p, this.maxDistancePoints);
                continue;
            }
            if (!s.matches("mine_factor_.*") || !((p = this.settings.getFloat(s, 1.0f, 0.0f, 10.0f)) > 0.0f)) continue;
            this.maxDistanceFactor = Math.max(p, this.maxDistanceFactor);
        }
    }

    @Override
    protected MinePathfinder.ISettingsProvider getFactorProvider() {
        return new FileSettingsProvider("mine_factor_", 0.0f, 0.0f, 10.0f);
    }

    @Override
    protected MinePathfinder.ISettingsProvider getPointsProvider() {
        return new FileSettingsProvider("mine_points_", 1.0f, 0.0f, 50.0f);
    }

    protected class FileSettingsProvider
    implements MinePathfinder.ISettingsProvider {
        private final String name_prefix;
        private final float defaultValue;
        private final float min;
        private final float max;

        public FileSettingsProvider(String name_prefix, float defaultValue, float min, float max) {
            this.name_prefix = name_prefix;
            this.defaultValue = defaultValue;
            this.min = min;
            this.max = max;
        }

        @Override
        public float getFloat(Block block) {
            String name = Block.field_149771_c.func_148750_c((Object)block).replace("minecraft:", "");
            float val = MineBySettingsPathFinder.this.settings.getFloat(this.name_prefix + name, this.defaultValue, this.min, this.max);
            System.out.println(this.name_prefix + name + " -> " + val);
            return val;
        }
    }
}

