/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.path;

import java.util.Random;
import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.BlockWhitelist;
import net.famzangl.minecraft.minebot.ai.path.MovePathFinder;
import net.famzangl.minecraft.minebot.ai.task.DestroyInRangeTask;
import net.minecraft.block.Block;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class MinePathfinder
extends MovePathFinder {
    protected static final float MIN_FACTOR = 0.1f;
    protected static final int MAX_FACTOR = 10;
    protected static final float MAX_POINTS = 50.0f;
    private static final int MAX_BLOCK_IDS = 4096;
    private final Random rand = new Random();
    protected float maxDistancePoints = 0.0f;
    protected float maxDistanceFactor = 1.0f;
    protected final ForgeDirection preferedDirection;
    protected final float preferedDirectionInfluence = 0.3f;
    protected final int preferedLayer;
    protected final float preferedLayerInfluence = 0.3f;
    private final FloatBlockCache points;
    private final FloatBlockCache factors;

    public MinePathfinder(ForgeDirection preferedDirection, int preferedLayer) {
        this.preferedDirection = preferedDirection;
        this.preferedLayer = preferedLayer;
        this.points = new FloatBlockCache(this.getPointsProvider());
        this.factors = new FloatBlockCache(this.getFactorProvider());
        for (String k : Block.field_149771_c.func_148742_b()) {
            int id = Block.func_149682_b((Block)((Block)Block.field_149771_c.func_82594_a(k)));
            float f = this.factors.getForBlock(id);
            if (!(f > 0.0f)) continue;
            this.headAllowedBlocks.intersectWith(new BlockWhitelist(id));
            this.footAllowedBlocks.intersectWith(new BlockWhitelist(id));
        }
    }

    protected abstract ISettingsProvider getFactorProvider();

    protected abstract ISettingsProvider getPointsProvider();

    @Override
    protected float rateDestination(int distance, int x, int y, int z) {
        int dz;
        float rating;
        float r1 = this.rateOreBlockDistance(distance, x, y + 1, z);
        float r2 = this.rateOreBlockDistance(distance, x, y, z);
        float addForDoubleMine = 0.0f;
        if (r1 == Float.POSITIVE_INFINITY || r2 == Float.POSITIVE_INFINITY) {
            addForDoubleMine = this.settings.getFloat("mine_double_add", 1.0f, 0.0f, 10.0f);
        }
        if ((rating = Math.min(r1, r2)) == Float.POSITIVE_INFINITY) {
            return -1.0f;
        }
        float badDirectionMalus = 0.0f;
        Pos current = this.helper.getPlayerPosition();
        if (this.preferedDirection != null && this.preferedDirection.offsetX != 0) {
            int dx = x - current.x;
            if (Math.signum(dx) != (float)this.preferedDirection.offsetX) {
                badDirectionMalus = (float)dx * 0.3f;
            }
        } else if (this.preferedDirection != null && this.preferedDirection.offsetZ != 0 && Math.signum(dz = z - current.z) != (float)this.preferedDirection.offsetZ) {
            badDirectionMalus = (float)dz * 0.3f;
        }
        float badY = (float)Math.abs(y - this.preferedLayer) * 0.3f;
        return this.makeRandom(rating + addForDoubleMine + badDirectionMalus + badY);
    }

    private float makeRandom(float f) {
        float r = this.settings.getFloat("mine_randomness", 0.0f, 0.0f, 1.0f) * this.rand.nextFloat();
        return f * (1.0f - r);
    }

    private float rateOreBlockDistance(int distance, int x, int y, int z) {
        int id = this.helper.getBlockId(x, y, z);
        float point = this.points.getForBlock(id);
        float factor = this.factors.getForBlock(id);
        return factor == 0.0f ? Float.POSITIVE_INFINITY : (float)distance / factor * this.maxDistanceFactor + this.maxDistancePoints - point;
    }

    private boolean isOreBlock(int x, int y, int z) {
        return this.factors.getForBlock(this.helper.getBlockId(x, y, z)) > 0.0f;
    }

    @Override
    protected void addTasksForTarget(Pos currentPos) {
        Pos top = this.isOreBlock(currentPos.x, currentPos.y + 1, currentPos.z) ? currentPos.add(0, 1, 0) : currentPos;
        Pos bottom = this.isOreBlock(currentPos.x, currentPos.y, currentPos.z) ? currentPos : currentPos.add(0, 1, 0);
        for (int i = 2; i < 5 && this.helper.hasSafeSides(currentPos.x, currentPos.y + i, currentPos.z) && this.helper.isSafeHeadBlock(currentPos.x, currentPos.y + i + 1, currentPos.z) && this.isOreBlock(currentPos.x, currentPos.y + i, currentPos.z); ++i) {
            top = currentPos.add(0, i, 0);
        }
        this.addTask(new DestroyInRangeTask(bottom, top));
    }

    @Override
    protected int materialDistance(int x, int y, int z, boolean onFloor) {
        return this.isOreBlock(x, y, z) ? 0 : super.materialDistance(x, y, z, onFloor);
    }

    private class FloatBlockCache {
        private final float[] cached = new float[4096];
        private final boolean[] isCached = new boolean[4096];
        private final ISettingsProvider settingsProvider;

        public FloatBlockCache(ISettingsProvider settingsProvider) {
            this.settingsProvider = settingsProvider;
        }

        public float getForBlock(int id) {
            if (!this.isCached[id]) {
                this.cached[id] = this.settingsProvider.getFloat((Block)Block.field_149771_c.func_148754_a(id));
                this.isCached[id] = true;
            }
            return this.cached[id];
        }
    }

    protected static interface ISettingsProvider {
        public float getFloat(Block var1);
    }
}

