/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.path;

import java.util.ArrayList;
import java.util.LinkedList;
import net.famzangl.minecraft.minebot.MinebotSettings;
import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.BlockItemFilter;
import net.famzangl.minecraft.minebot.ai.BlockWhitelist;
import net.famzangl.minecraft.minebot.ai.PathFinderField;
import net.famzangl.minecraft.minebot.ai.path.PlaceTorchIfLightBelowTask;
import net.famzangl.minecraft.minebot.ai.path.TaskReceiver;
import net.famzangl.minecraft.minebot.ai.task.AITask;
import net.famzangl.minecraft.minebot.ai.task.move.AlignToGridTask;
import net.famzangl.minecraft.minebot.ai.task.move.DownwardsMoveTask;
import net.famzangl.minecraft.minebot.ai.task.move.HorizontalMoveTask;
import net.famzangl.minecraft.minebot.ai.task.move.JumpMoveTask;
import net.famzangl.minecraft.minebot.ai.task.move.UpwardsMoveTask;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.util.ForgeDirection;

public class MovePathFinder
extends PathFinderField {
    protected Block[] upwardsBuildBlocks = new Block[]{Blocks.field_150346_d, Blocks.field_150348_b, Blocks.field_150347_e};
    protected AIHelper helper;
    protected MinebotSettings settings;
    protected float torchLightLevel;
    protected static final BlockWhitelist defaultForbiddenBlocks = new BlockWhitelist(new Block[]{Blocks.field_150357_h, Blocks.field_150434_aF, Blocks.field_150343_Z, Blocks.field_150326_M, Blocks.field_150332_K});
    protected BlockWhitelist allowedGroundBlocks = AIHelper.safeStandableBlocks;
    protected BlockWhitelist allowedGroundForUpwardsBlocks = AIHelper.safeStandableBlocks.unionWith(AIHelper.walkableBlocks);
    protected BlockWhitelist footAllowedBlocks;
    protected BlockWhitelist headAllowedBlocks = this.footAllowedBlocks = AIHelper.safeDestructableBlocks.unionWith(AIHelper.safeHeadBlocks).unionWith(AIHelper.fallingBlocks).intersectWith(defaultForbiddenBlocks.invert());
    private TaskReceiver receiver;
    protected static final BlockWhitelist fastDestructableBlocks = new BlockWhitelist(Blocks.field_150346_d, Blocks.field_150351_n, Blocks.field_150354_m, Blocks.field_150322_A);

    public MovePathFinder() {
        this.settings = new MinebotSettings();
        ArrayList<Block> blocks = new ArrayList<Block>();
        String upwardsBuildBlockNames = this.settings.get("upwards_place_block", "dirt,stone,cobblestone");
        for (String name : upwardsBuildBlockNames.split("\\s*[\\,\\s\\;]\\s*")) {
            Block block = (Block)Block.field_149771_c.func_82594_a(name);
            if (block != null) {
                blocks.add(block);
                continue;
            }
            System.out.println("Invalid block name: " + name);
        }
        this.upwardsBuildBlocks = blocks.toArray(new Block[blocks.size()]);
        this.torchLightLevel = this.settings.getFloat("place_torches_at", 1.0f, -1.0f, 15.0f);
    }

    @Override
    protected final boolean searchSomethingAround(int cx, int cy, int cz) {
        throw new UnsupportedOperationException("Direct call not supported.");
    }

    protected void addTask(AITask task) {
        this.receiver.addTask(task);
    }

    public final boolean searchSomethingAround(Pos playerPosition, AIHelper helper, TaskReceiver receiver) {
        this.helper = helper;
        this.receiver = receiver;
        return this.runSearch(playerPosition);
    }

    protected boolean runSearch(Pos playerPosition) {
        return super.searchSomethingAround(playerPosition.x, playerPosition.y, playerPosition.z);
    }

    @Override
    protected int getNeighbour(int currentNode, int cx, int cy, int cz) {
        int res = super.getNeighbour(currentNode, cx, cy, cz);
        if (res > 0 && !this.isSafeToTravel(currentNode, cx, cy, cz)) {
            return -1;
        }
        return res;
    }

    protected boolean isSafeToTravel(int currentNode, int cx, int cy, int cz) {
        return this.helper.hasSafeSides(cx, cy + 1, cz) && this.isAllowedPosition(cx, cy, cz) && this.helper.hasSafeSides(cx, cy, cz) && this.checkHeadBlock(currentNode, cx, cy, cz) && this.checkGroundBlock(currentNode, cx, cy, cz);
    }

    private boolean isAllowedPosition(int cx, int cy, int cz) {
        return this.footAllowedBlocks.contains(this.helper.getBlockId(cx, cy, cz)) && this.headAllowedBlocks.contains(this.helper.getBlockId(cx, cy + 1, cz));
    }

    protected boolean checkGroundBlock(int currentNode, int cx, int cy, int cz) {
        if (this.getY(currentNode) < cy) {
            return this.allowedGroundForUpwardsBlocks.contains(this.helper.getBlockId(cx, cy - 1, cz));
        }
        return this.allowedGroundBlocks.contains(this.helper.getBlockId(cx, cy - 1, cz));
    }

    private boolean checkHeadBlock(int currentNode, int cx, int cy, int cz) {
        if (this.getY(currentNode) > cy) {
            if (this.getX(currentNode) != cx || this.getZ(currentNode) != cz) {
                return this.helper.isSafeHeadBlock(cx, cy + 3, cz) && AIHelper.headWalkableBlocks.contains(this.helper.getBlockId(cx, cy + 2, cz));
            }
            if (this.helper.isFallingBlock(cx, cy + 2, cz)) {
                return true;
            }
        }
        return this.helper.isSafeHeadBlock(cx, cy + 2, cz);
    }

    @Override
    protected void noPathFound() {
        super.noPathFound();
    }

    @Override
    protected void foundPath(LinkedList<Pos> path) {
        super.foundPath(path);
        Pos currentPos = path.removeFirst();
        this.addTask(new AlignToGridTask(currentPos.x, currentPos.y, currentPos.z));
        while (!path.isEmpty()) {
            Pos nextPos = path.removeFirst();
            ForgeDirection moveDirection = this.direction(currentPos, nextPos);
            if (this.torchLightLevel >= 0.0f && moveDirection != ForgeDirection.UP) {
                ForgeDirection direction = moveDirection == ForgeDirection.UP ? ForgeDirection.DOWN : moveDirection;
                this.addTask(new PlaceTorchIfLightBelowTask(currentPos, direction, this.torchLightLevel));
            }
            Pos peeked = path.peekFirst();
            if (moveDirection == ForgeDirection.UP && peeked != null && nextPos.subtract((Pos)peeked).y == 0) {
                this.addTask(new JumpMoveTask(peeked.x, peeked.y, peeked.z, nextPos.x, nextPos.z));
                nextPos = peeked;
                path.removeFirst();
            } else if (nextPos.y > currentPos.y) {
                this.addTask(new UpwardsMoveTask(nextPos.x, nextPos.y, nextPos.z, new BlockItemFilter(this.upwardsBuildBlocks)));
            } else if (nextPos.y < currentPos.y && nextPos.x == currentPos.x && nextPos.z == currentPos.z) {
                this.addTask(new DownwardsMoveTask(nextPos.x, nextPos.y, nextPos.z));
            } else {
                this.addTask(new HorizontalMoveTask(nextPos.x, nextPos.y, nextPos.z));
            }
            currentPos = nextPos;
        }
        this.addTasksForTarget(currentPos);
    }

    private ForgeDirection direction(Pos currentPos, Pos nextPos) {
        Pos delta = nextPos.subtract(currentPos);
        if (delta.y != 0 && (delta.x != 0 || delta.z != 0)) {
            delta = new Pos(delta.x, 0, delta.z);
        }
        return AIHelper.getDirectionFor(delta);
    }

    protected void addTasksForTarget(Pos currentPos) {
    }

    @Override
    protected int distanceFor(int from, int to) {
        int distance = 0;
        ++distance;
        if (this.getY(from) >= this.getY(to)) {
            distance += this.materialDistance(this.getX(to), this.getY(to), this.getZ(to), true);
        }
        if (this.getY(from) <= this.getY(to)) {
            distance += this.materialDistance(this.getX(to), this.getY(to) + 1, this.getZ(to), false);
        }
        return distance;
    }

    protected int materialDistance(int x, int y, int z, boolean asFloor) {
        Block block = this.helper.getBlock(x, y, z);
        if (asFloor && this.helper.canWalkOn(block) || !asFloor && this.helper.canWalkThrough(block)) {
            return 0;
        }
        if (fastDestructableBlocks.contains(block)) {
            return 1;
        }
        return 2;
    }
}

