/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.path;

import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.path.MovePathFinder;
import net.famzangl.minecraft.minebot.ai.task.MineBlockTask;
import net.famzangl.minecraft.minebot.ai.task.WaitTask;
import net.famzangl.minecraft.minebot.ai.task.place.ReplantTask;
import net.famzangl.minecraft.minebot.build.WoodType;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class TreePathFinder
extends MovePathFinder {
    private final WoodType type;
    private final boolean replant;
    private static final int TREE_HEIGHT = 7;

    public TreePathFinder(WoodType type, boolean replant) {
        this.type = type;
        this.replant = replant;
    }

    @Override
    protected float rateDestination(int distance, int x, int y, int z) {
        int points = 0;
        if (this.isTree(x, y, z)) {
            ++points;
        }
        if (this.isTree(x, y + 1, z)) {
            ++points;
        }
        for (int i = 2; i < 7 && this.helper.hasSafeSides(x, y + i, z) && this.helper.isSafeHeadBlock(x, y + i + 1, z); ++i) {
            if (!this.isTree(x, y + i, z)) continue;
            ++points;
        }
        return points == 0 ? -1.0f : (float)(distance + 20 - points * 2);
    }

    private boolean isTree(int x, int y, int z) {
        Block block = this.helper.getBlock(x, y, z);
        if (this.type == null) {
            return Block.func_149680_a((Block)block, (Block)Blocks.field_150364_r) || Block.func_149680_a((Block)block, (Block)Blocks.field_150363_s);
        }
        return Block.func_149680_a((Block)block, (Block)this.type.block) && (3 & this.helper.getMinecraft().field_71441_e.func_72805_g(x, y, z)) == this.type.lowerBits;
    }

    @Override
    protected void addTasksForTarget(Pos currentPos) {
        int i;
        int mineAbove = 0;
        for (i = 2; i < 7; ++i) {
            if (!this.isTree(currentPos.x, currentPos.y + i, currentPos.z)) continue;
            mineAbove = i;
        }
        for (i = 2; i <= mineAbove && this.helper.hasSafeSides(currentPos.x, currentPos.y + i, currentPos.z) && this.helper.isSafeHeadBlock(currentPos.x, currentPos.y + i + 1, currentPos.z); ++i) {
            if (this.helper.isAirBlock(currentPos.x, currentPos.y + i, currentPos.z)) continue;
            this.addTask(new MineBlockTask(currentPos.x, currentPos.y + i, currentPos.z));
        }
        if (this.replant) {
            this.addTask(new ReplantTask(currentPos.x, currentPos.y, currentPos.z));
        }
        this.addTask(new WaitTask(mineAbove * 2));
    }
}

