/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.path;

import java.util.ArrayList;
import java.util.Collections;
import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.path.AlongTrackPathFinder;
import net.famzangl.minecraft.minebot.ai.task.DestroyInRangeTask;
import net.famzangl.minecraft.minebot.ai.task.PlaceTorchSomewhereTask;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.util.ForgeDirection;

public class TunnelPathFinder
extends AlongTrackPathFinder {
    private final int addToSide;
    private final int addToTop;
    private final TorchSide torches;

    public TunnelPathFinder(int dx, int dz, int cx, int cy, int cz, int addToSide, int addToTop, TorchSide torches, Integer length) {
        super(dx, dz, cx, cy, cz, length);
        this.addToSide = addToSide;
        this.addToTop = addToTop;
        this.torches = torches;
    }

    @Override
    protected float rateDestination(int distance, int x, int y, int z) {
        if (this.isOnTrack(x, z) && y == this.cy && !AIHelper.blockIsOneOf(this.helper.getBlock(x, y, z), Blocks.field_150350_a, Blocks.field_150478_aa)) {
            return distance + 1;
        }
        return -1.0f;
    }

    @Override
    protected void addTasksForTarget(Pos currentPos) {
        boolean isTorchStep;
        Pos p2;
        Pos p1;
        if (this.dx == 0) {
            p1 = new Pos(currentPos.x + this.addToSide, currentPos.y, currentPos.z);
            p2 = new Pos(currentPos.x - this.addToSide, currentPos.y + 1 + this.addToTop, currentPos.z);
        } else {
            p1 = new Pos(currentPos.x, currentPos.y, currentPos.z + this.addToSide);
            p2 = new Pos(currentPos.x, currentPos.y + 1 + this.addToTop, currentPos.z - this.addToSide);
        }
        this.addTask(new DestroyInRangeTask(p1, p2));
        boolean bl = isTorchStep = this.getStepNumber(currentPos.x, currentPos.z) % 8 == 0;
        if (this.torches.right && isTorchStep) {
            this.addTorchesTask(currentPos, -this.dz, this.dx);
        }
        if (this.torches.left && isTorchStep) {
            this.addTorchesTask(currentPos, this.dz, -this.dx);
        }
        if (this.torches.floor && isTorchStep) {
            this.addTask(new PlaceTorchSomewhereTask(Collections.singletonList(currentPos), ForgeDirection.DOWN));
        }
    }

    private void addTorchesTask(Pos currentPos, int dirX, int dirZ) {
        ArrayList<Pos> positions = new ArrayList<Pos>();
        positions.add(new Pos(currentPos.x + dirX * this.addToSide, currentPos.y + 1, currentPos.z + dirZ * this.addToSide));
        for (int i = this.addToSide; i >= 0; --i) {
            positions.add(new Pos(currentPos.x + dirX * i, currentPos.y, currentPos.z + dirZ * i));
        }
        this.addTask(new PlaceTorchSomewhereTask(positions, AIHelper.getDirectionForXZ(dirX, dirZ), ForgeDirection.DOWN));
    }

    public String toString() {
        return "TunnelPathFinder [addToSide=" + this.addToSide + ", addToTop=" + this.addToTop + ", dx=" + this.dx + ", dz=" + this.dz + ", cx=" + this.cx + ", cy=" + this.cy + ", cz=" + this.cz + ", torches=" + (Object)((Object)this.torches) + "]";
    }

    public static enum TorchSide {
        NONE(false, false, false),
        LEFT(true, false, false),
        RIGHT(false, true, false),
        BOTH(true, true, false),
        FLOOR(false, false, true);

        private final boolean left;
        private final boolean right;
        private final boolean floor;

        private TorchSide(boolean left, boolean right, boolean floor) {
            this.left = left;
            this.right = right;
            this.floor = floor;
        }
    }
}

