/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.scanner;

import java.util.BitSet;
import net.famzangl.minecraft.minebot.Pos;

public class BlockFlagTable {
    private final BitSet bits = new BitSet();
    private final Pos max;
    private final Pos min;

    public BlockFlagTable(Pos pos1, Pos pos2) {
        this.max = Pos.maxPos(pos1, pos2);
        this.min = Pos.minPos(pos1, pos2);
    }

    public void setBit(int x, int y, int z, boolean value) {
        int index = this.getIndex(x, y, z);
        if (index >= 0) {
            this.bits.set(index, value);
        }
    }

    public boolean getBit(int x, int y, int z) {
        int index = this.getIndex(x, y, z);
        if (index >= 0) {
            return this.bits.get(index);
        }
        return false;
    }

    private int getIndex(int x, int y, int z) {
        if (x < this.min.x || x > this.max.x || y < this.min.y || y > this.max.y || z < this.min.z || z > this.max.z) {
            return -1;
        }
        int v = z - this.min.z;
        v *= this.max.y - this.min.y + 1;
        v += y - this.min.y;
        v *= this.max.x - this.min.x + 1;
        return v += x - this.min.x;
    }
}

