/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.scanner;

import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.path.MovePathFinder;
import net.famzangl.minecraft.minebot.ai.scanner.BlockRangeScanner;

public class BlockRangeFinder
extends MovePathFinder {
    protected BlockRangeScanner rangeScanner;

    public BlockRangeFinder() {
        this.allowedGroundForUpwardsBlocks = this.allowedGroundBlocks;
        this.footAllowedBlocks = AIHelper.walkableBlocks;
        this.headAllowedBlocks = AIHelper.headWalkableBlocks;
    }

    @Override
    protected boolean runSearch(Pos playerPosition) {
        if (this.rangeScanner == null) {
            this.rangeScanner = this.constructScanner(playerPosition);
            this.rangeScanner.startAsync(this.helper);
            return false;
        }
        if (!this.rangeScanner.isScaningFinished()) {
            return false;
        }
        return super.runSearch(playerPosition);
    }

    protected BlockRangeScanner constructScanner(Pos playerPosition) {
        return new BlockRangeScanner(playerPosition);
    }
}

