/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.scanner;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.ItemFilter;
import net.famzangl.minecraft.minebot.ai.scanner.BlockRangeScanner;
import net.famzangl.minecraft.minebot.ai.scanner.SameItemFilter;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class ChestBlockHandler
implements BlockRangeScanner.BlockHandler {
    private static final int[] IDS = new int[]{Block.func_149682_b((Block)Blocks.field_150486_ae)};
    private final Hashtable<Pos, ChestData> chests = new Hashtable();
    private final Hashtable<Pos, ArrayList<ChestData>> reachable = new Hashtable();

    @Override
    public int[] getIds() {
        return IDS;
    }

    @Override
    public void scanningDone(AIHelper helper) {
        this.updatePositionCache(helper);
    }

    private void updatePositionCache(AIHelper helper) {
        this.reachable.clear();
        for (ChestData c : this.chests.values()) {
            for (ForgeDirection d : new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST}) {
                this.addChestPositions(helper, c.pos, c, d);
                if (c.secondaryPos == null) continue;
                this.addChestPositions(helper, c.secondaryPos, c, d);
            }
        }
    }

    private void addChestPositions(AIHelper helper, Pos pos, ChestData c, ForgeDirection d) {
        int dvertMax = 4;
        for (int dhor = 0; dhor < 4; ++dhor) {
            int y = pos.y - dhor;
            for (int dvert = 1; dvert <= dvertMax; ++dvert) {
                int x = pos.x + dvert * d.offsetX;
                int z = pos.z + dvert * d.offsetZ;
                if (!helper.isAirBlock(x, y, z)) {
                    dvertMax = dvert;
                    continue;
                }
                Pos allowed = new Pos(x, y, z);
                this.addReachable(allowed, c);
            }
        }
    }

    private void addReachable(Pos allowed, ChestData c) {
        ArrayList<ChestData> list = this.reachable.get(allowed);
        if (list == null) {
            list = new ArrayList();
            this.reachable.put(allowed, list);
        }
        list.add(c);
    }

    @Override
    public void scanBlock(AIHelper helper, int id, int x, int y, int z) {
        if (helper.getBlock(x, y, z) instanceof BlockChest) {
            AxisAlignedBB abb = AxisAlignedBB.func_72330_a((double)(x - 1), (double)y, (double)(z - 1), (double)(x + 2), (double)(y + 1), (double)(z + 2));
            List frames = helper.getMinecraft().field_71441_e.func_72872_a(EntityItemFrame.class, abb);
            for (EntityItemFrame f : frames) {
                ForgeDirection direction = this.getDirection(f);
                if (direction == null) continue;
                int frameX = f.field_146063_b;
                int frameY = f.field_146064_c;
                int frameZ = f.field_146062_d;
                if (x != frameX || y != frameY || z != frameZ) continue;
                this.registerChest(new Pos(x, y, z), f);
            }
        }
    }

    private void registerChest(Pos pos, EntityItemFrame f) {
        ItemStack displayed;
        ChestData chest = null;
        for (ForgeDirection d : new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST}) {
            Pos p = pos.add(d.offsetX, 0, d.offsetZ);
            if (!this.chests.containsKey(p) || (chest = this.chests.get(p)).pos.equals(pos)) continue;
            chest.secondaryPos = pos;
        }
        if (chest == null) {
            chest = new ChestData(pos);
            this.chests.put(pos, chest);
        }
        if ((displayed = f.func_82335_i()) != null) {
            chest.allowItem(displayed);
        }
    }

    private ForgeDirection getDirection(EntityItemFrame f) {
        switch (f.field_82332_a) {
            case 0: {
                return ForgeDirection.NORTH;
            }
            case 2: {
                return ForgeDirection.SOUTH;
            }
            case 1: {
                return ForgeDirection.EAST;
            }
            case 3: {
                return ForgeDirection.WEST;
            }
        }
        return null;
    }

    public ArrayList<ChestData> getChestsForPos(Pos pos) {
        return this.reachable.get(pos);
    }

    public static class ChestData {
        private final Pos pos;
        private final ArrayList<ItemFilter> allowedItems = new ArrayList();
        private final ArrayList<ItemFilter> fullItems = new ArrayList();
        private final ArrayList<ItemFilter> emptyItems = new ArrayList();
        public Pos secondaryPos;

        public ChestData(Pos pos) {
            this.pos = pos;
        }

        public boolean isItemAllowed(ItemStack stack) {
            for (ItemFilter f : this.allowedItems) {
                if (!f.matches(stack)) continue;
                return true;
            }
            return false;
        }

        public boolean couldPutItem(ItemStack stack) {
            for (ItemFilter f : this.fullItems) {
                if (!f.matches(stack)) continue;
                return false;
            }
            return this.isItemAllowed(stack);
        }

        public boolean couldTakeItem(ItemStack stack) {
            for (ItemFilter f : this.emptyItems) {
                if (!f.matches(stack)) continue;
                return false;
            }
            return this.isItemAllowed(stack);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.pos == null ? 0 : this.pos.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChestData other = (ChestData)obj;
            return !(this.pos == null ? other.pos != null : !this.pos.equals(other.pos));
        }

        public String toString() {
            return "ChestData [pos=" + this.pos + ", allowedItems=" + this.allowedItems + "]";
        }

        public void allowItem(ItemStack displayed) {
            this.allowedItems.add(new SameItemFilter(displayed));
        }

        public Pos getPos() {
            return this.pos;
        }

        public Pos getSecondaryPos() {
            return this.secondaryPos;
        }

        public void markAsFullFor(ItemStack s, boolean full) {
            this.removeFrom(this.fullItems, s);
            if (full) {
                this.fullItems.add(new SameItemFilter(s));
            }
        }

        public void markAsEmptyFor(ItemStack s, boolean empty) {
            this.removeFrom(this.emptyItems, s);
            if (empty) {
                this.emptyItems.add(new SameItemFilter(s));
            }
        }

        private void removeFrom(ArrayList<ItemFilter> list, ItemStack s) {
            Iterator<ItemFilter> iterator = list.iterator();
            while (iterator.hasNext()) {
                ItemFilter filter = iterator.next();
                if (!filter.matches(s)) continue;
                iterator.remove();
            }
        }
    }
}

