/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.scripting;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.command.AIChatController;
import net.famzangl.minecraft.minebot.ai.command.AICommand;
import net.famzangl.minecraft.minebot.ai.command.AICommandInvocation;
import net.famzangl.minecraft.minebot.ai.command.AICommandParameter;
import net.famzangl.minecraft.minebot.ai.command.ParameterType;
import net.famzangl.minecraft.minebot.ai.command.UnknownCommandException;
import net.famzangl.minecraft.minebot.ai.commands.CommandRun;
import net.famzangl.minecraft.minebot.ai.strategy.AIStrategy;
import net.famzangl.minecraft.minebot.ai.strategy.StackStrategy;
import net.famzangl.minecraft.minebot.ai.strategy.StrategyStack;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;

@AICommand(name="minebot", helpText="Execute a javascript file.")
public class CommandJs {
    @AICommandInvocation
    public static AIStrategy run(AIHelper helper, @AICommandParameter(type=ParameterType.FIXED, fixedName="js", description="") String nameArg, @AICommandParameter(type=ParameterType.FILE, description="") String file) {
        return new RunScriptStrategy(file);
    }

    public static class RunScriptStrategy
    extends AIStrategy {
        private final ScriptRunner scriptRunner;

        public RunScriptStrategy(String fileName) {
            this.scriptRunner = new ScriptRunner(fileName);
        }

        @Override
        protected void onActivate(AIHelper helper) {
            Thread scriptThread = new Thread(this.scriptRunner);
            scriptThread.start();
            super.onActivate(helper);
        }

        @Override
        protected void onDeactivate(AIHelper helper) {
            this.scriptRunner.stop();
            super.onDeactivate(helper);
        }

        @Override
        public boolean checkShouldTakeOver(AIHelper helper) {
            return !this.scriptRunner.isFinished();
        }

        @Override
        protected AIStrategy.TickResult onGameTick(AIHelper helper) {
            return this.scriptRunner.runForTick(helper);
        }

        @Override
        public String getDescription(AIHelper helper) {
            return this.scriptRunner.getDescription(helper);
        }
    }

    public static class ScriptRunner
    implements Runnable,
    TickProvider {
        private String description = "Running script";
        private final String fileName;
        private boolean finished;
        private AIHelper tickHelper;
        private final Object tickHelperMutex = new Object();
        private boolean scriptInsideTick = false;
        private boolean scriptWaitingForTick = false;
        private boolean stopped;
        private AIStrategy activeStrategy;
        private final Object activeStrategyMutex = new Object();

        public ScriptRunner(String fileName) {
            this.fileName = fileName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object = this.tickHelperMutex;
                synchronized (object) {
                    if (this.stopped) {
                        throw new RuntimeException("Cannot reactivate.");
                    }
                }
                ScriptEngineManager manager = new ScriptEngineManager();
                ScriptEngine engine = manager.getEngineByName("JavaScript");
                FileReader fis = new FileReader(this.fileName);
                engine.put("minescript", new MineScript(this));
                engine.eval(fis);
            }
            catch (ScriptException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            finally {
                this.finished = true;
                this.tickDone();
            }
        }

        public boolean isFinished() {
            return this.finished;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AIStrategy.TickResult runForTick(AIHelper helper) {
            Object object = this.tickHelperMutex;
            synchronized (object) {
                Object object2 = this.activeStrategyMutex;
                synchronized (object2) {
                    if (this.activeStrategy != null) {
                        AIStrategy.TickResult tickResult = this.activeStrategy.gameTick(helper);
                        if (tickResult == AIStrategy.TickResult.NO_MORE_WORK || tickResult == AIStrategy.TickResult.ABORT) {
                            this.activeStrategy.setActive(false, helper);
                            this.activeStrategy = null;
                            this.activeStrategyMutex.notifyAll();
                        } else {
                            return tickResult;
                        }
                    }
                }
                if (this.scriptWaitingForTick) {
                    this.tickHelper = helper;
                    this.scriptInsideTick = true;
                    this.scriptWaitingForTick = false;
                    this.tickHelperMutex.notifyAll();
                    while (this.scriptInsideTick) {
                        try {
                            this.tickHelperMutex.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.tickHelper = null;
                }
                return this.finished ? AIStrategy.TickResult.NO_MORE_WORK : AIStrategy.TickResult.TICK_HANDLED;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void tickDone() {
            Object object = this.tickHelperMutex;
            synchronized (object) {
                this.scriptInsideTick = false;
                this.scriptWaitingForTick = false;
                this.tickHelperMutex.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AIHelper getHelper() {
            Object object = this.tickHelperMutex;
            synchronized (object) {
                if (this.stopped) {
                    throw new RuntimeException("Stop.");
                }
                while (this.tickHelper == null) {
                    try {
                        this.scriptWaitingForTick = true;
                        this.tickHelperMutex.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.scriptInsideTick = true;
                return this.tickHelper;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.tickHelperMutex;
            synchronized (object) {
                this.stopped = true;
            }
        }

        @Override
        public void setDescription(String description) {
            this.description = description;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setActiveStrategy(ScriptStrategy strategy, AIHelper helper) {
            Object object = this.activeStrategyMutex;
            synchronized (object) {
                if (this.activeStrategy != null) {
                    this.activeStrategy.setActive(false, helper);
                }
                AIStrategy aIStrategy = this.activeStrategy = strategy == null ? null : strategy.getStrategy();
                if (this.activeStrategy != null) {
                    this.activeStrategy.setActive(true, helper);
                }
                this.activeStrategyMutex.notifyAll();
            }
        }

        public String getDescription(AIHelper helper) {
            int lastSlash = this.fileName.lastIndexOf("/") + 1;
            return this.fileName.substring(lastSlash) + ": " + this.description;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pauseForStrategy() {
            Object object = this.activeStrategyMutex;
            synchronized (object) {
                while (this.activeStrategy != null) {
                    try {
                        this.activeStrategyMutex.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    public static class MineScript {
        private final TickProvider tickProvider;

        public MineScript(TickProvider tickProvider) {
            this.tickProvider = tickProvider;
        }

        private AIHelper waitForTick() {
            return this.tickProvider.getHelper();
        }

        public ScriptStrategy safeStrategy(String command, String ... arguments) throws UnknownCommandException {
            return new ScriptStrategy(AIChatController.getRegistry().evaluateCommandWithSaferule(this.waitForTick(), command, arguments));
        }

        public ScriptStrategy strategy(String command, String ... arguments) throws UnknownCommandException {
            return new ScriptStrategy(AIChatController.getRegistry().evaluateCommand(this.waitForTick(), command, arguments));
        }

        public Pos getPlayerPosition() {
            return this.waitForTick().getPlayerPosition();
        }

        public FoundEntity[] getEntities(Class clazz, double range) {
            AIHelper helper = this.waitForTick();
            Vec3 p = helper.getMinecraft().field_71439_g.func_70666_h(1.0f);
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(p.field_72450_a - range), (double)(p.field_72448_b - range), (double)(p.field_72449_c - range), (double)(p.field_72450_a + range), (double)(p.field_72448_b + range), (double)(p.field_72449_c + range));
            List es = helper.getMinecraft().field_71441_e.func_72872_a(clazz, box);
            FoundEntity[] res = new FoundEntity[es.size()];
            for (int i = 0; i < res.length; ++i) {
                res[i] = new FoundEntity((Entity)es.get(i));
            }
            return res;
        }

        public void displayChat(String message) {
            AIChatController.addChatLine(message);
        }

        public boolean isAlive() {
            return this.waitForTick().isAlive();
        }

        public int getExperienceLevel() {
            return this.waitForTick().getMinecraft().field_71439_g.field_71068_ca;
        }

        public int getCurrentTime() {
            return (int)(this.waitForTick().getMinecraft().field_71441_e.func_72820_D() % 24000L);
        }

        public ScriptStrategy stack(ScriptStrategy ... strats) {
            StrategyStack stack = new StrategyStack();
            for (ScriptStrategy s : strats) {
                stack.addStrategy(s.getStrategy());
            }
            return new ScriptStrategy(new StackStrategy(stack));
        }

        public void doNothing() {
            this.tickProvider.setActiveStrategy(null, this.waitForTick());
            this.tickProvider.tickDone();
        }

        public void doStrategy(ScriptStrategy strategy) {
            this.tickProvider.setActiveStrategy(strategy, this.waitForTick());
            this.tickProvider.tickDone();
            this.tickProvider.pauseForStrategy();
        }

        public void setDescription(String description) {
            this.tickProvider.setDescription(description);
        }

        public void serverCommand(String command) {
            CommandRun.runCommand(this.waitForTick(), command);
            this.tickProvider.tickDone();
        }
    }

    public static interface TickProvider {
        public AIHelper getHelper();

        public void setDescription(String var1);

        public void setActiveStrategy(ScriptStrategy var1, AIHelper var2);

        public void tickDone();

        public void pauseForStrategy();
    }

    public static class ScriptStrategy {
        private final AIStrategy strategy;

        public ScriptStrategy(AIStrategy strategy) {
            this.strategy = strategy;
        }

        protected AIStrategy getStrategy() {
            return this.strategy;
        }
    }

    public static class FoundEntity {
        private final Entity entity;
        private final Pos pos;

        public FoundEntity(Entity entity) {
            this.entity = entity;
            this.pos = new Pos((int)Math.floor(entity.field_70165_t), (int)Math.floor(entity.field_70163_u), (int)Math.floor(entity.field_70161_v));
        }

        public Pos getPos() {
            return this.pos;
        }

        public Class<?> getType() {
            return this.entity.getClass();
        }

        public String getTypeName() {
            return this.entity.getClass().getSimpleName();
        }
    }
}

