/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.strategy;

import net.famzangl.minecraft.minebot.ai.AIHelper;

public abstract class AIStrategy {
    private boolean active;

    public final void setActive(boolean active, AIHelper helper) {
        this.active = active;
        if (active) {
            this.onActivate(helper);
        } else {
            this.onDeactivate(helper);
        }
    }

    public final boolean isActive() {
        return this.active;
    }

    protected void onDeactivate(AIHelper helper) {
    }

    protected void onActivate(AIHelper helper) {
    }

    public boolean takesOverAnyTime() {
        return false;
    }

    public boolean checkShouldTakeOver(AIHelper helper) {
        if (this.active) {
            throw new IllegalStateException();
        }
        return true;
    }

    public final TickResult gameTick(AIHelper helper) {
        if (!this.active) {
            throw new IllegalStateException();
        }
        return this.onGameTick(helper);
    }

    protected abstract TickResult onGameTick(AIHelper var1);

    public String getDescription(AIHelper helper) {
        return "No description so far... " + this.getClass().getSimpleName();
    }

    public static enum TickResult {
        TICK_AGAIN,
        TICK_HANDLED,
        NO_MORE_WORK,
        ABORT;

    }
}

