/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.strategy;

import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.strategy.AIStrategy;

public class DoNotSuffocateStrategy
extends AIStrategy {
    @Override
    public boolean takesOverAnyTime() {
        return true;
    }

    @Override
    public boolean checkShouldTakeOver(AIHelper helper) {
        Pos p = helper.getPlayerPosition();
        return !this.safeGround(helper, p) || !this.safeHead(helper, p);
    }

    @Override
    protected AIStrategy.TickResult onGameTick(AIHelper helper) {
        Pos p = helper.getPlayerPosition();
        if (!this.safeGround(helper, p)) {
            helper.faceAndDestroy(p.x, p.y, p.z);
            return AIStrategy.TickResult.TICK_HANDLED;
        }
        if (!this.safeHead(helper, p)) {
            helper.faceAndDestroy(p.x, p.y + 1, p.z);
            return AIStrategy.TickResult.TICK_HANDLED;
        }
        return AIStrategy.TickResult.NO_MORE_WORK;
    }

    private boolean safeHead(AIHelper helper, Pos p) {
        return helper.canWalkThrough(helper.getBlock(p.x, p.y + 1, p.z));
    }

    private boolean safeGround(AIHelper helper, Pos p) {
        return helper.canWalkOn(helper.getBlock(p.x, p.y, p.z));
    }

    @Override
    public String getDescription(AIHelper helper) {
        return "Do not suffocate in walls.";
    }
}

