/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.strategy;

import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.ItemFilter;
import net.famzangl.minecraft.minebot.ai.command.AIChatController;
import net.famzangl.minecraft.minebot.ai.strategy.AIStrategy;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;

public class EatStrategy
extends AIStrategy {
    private static final ItemFilter FILTER = new ItemFilter(){

        @Override
        public boolean matches(ItemStack itemStack) {
            return itemStack != null && itemStack.func_77973_b() instanceof ItemFood;
        }
    };

    @Override
    public boolean checkShouldTakeOver(AIHelper helper) {
        return this.needFood(helper) && helper.canSelectItem(FILTER);
    }

    private boolean needFood(AIHelper helper) {
        return helper.getMinecraft().field_71439_g.func_71024_bL().func_75121_c();
    }

    @Override
    protected AIStrategy.TickResult onGameTick(AIHelper helper) {
        if (this.needFood(helper)) {
            if (helper.selectCurrentItem(FILTER)) {
                helper.overrideSneak();
                helper.overrideUseItem();
                return AIStrategy.TickResult.TICK_HANDLED;
            }
            AIChatController.addChatLine("Could not find anything to eat");
            return AIStrategy.TickResult.NO_MORE_WORK;
        }
        return AIStrategy.TickResult.NO_MORE_WORK;
    }

    @Override
    public String getDescription(AIHelper helper) {
        return "Eat.";
    }
}

