/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.strategy;

import java.util.HashSet;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.animals.AnimalyType;
import net.famzangl.minecraft.minebot.ai.selectors.AndSelector;
import net.famzangl.minecraft.minebot.ai.selectors.ItemSelector;
import net.famzangl.minecraft.minebot.ai.selectors.NotSelector;
import net.famzangl.minecraft.minebot.ai.selectors.OrSelector;
import net.famzangl.minecraft.minebot.ai.selectors.OwnTameableSelector;
import net.famzangl.minecraft.minebot.ai.selectors.XPOrbSelector;
import net.famzangl.minecraft.minebot.ai.strategy.AIStrategy;
import net.famzangl.minecraft.minebot.ai.strategy.FaceInteractStrategy;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;

public class KillAnimalsStrategy
extends FaceInteractStrategy {
    private final int maxKills;
    private final AnimalyType type;
    private final HashSet<Entity> hitEntities = new HashSet();

    public KillAnimalsStrategy() {
        this(-1, AnimalyType.ANY);
    }

    public KillAnimalsStrategy(int maxKills, AnimalyType type) {
        this.maxKills = maxKills;
        this.type = type;
    }

    @Override
    public boolean checkShouldTakeOver(AIHelper helper) {
        return super.checkShouldTakeOver(helper);
    }

    @Override
    protected AIStrategy.TickResult onGameTick(AIHelper helper) {
        return super.onGameTick(helper);
    }

    @Override
    protected IEntitySelector entitiesToInteract(AIHelper helper) {
        if (this.maxKillsReached(helper)) {
            return new IEntitySelector(){

                public boolean func_82704_a(Entity var1) {
                    return false;
                }
            };
        }
        return new AndSelector(new KillableSelector(), new NotSelector(new OwnTameableSelector((EntityLivingBase)helper.getMinecraft().field_71439_g)));
    }

    @Override
    protected IEntitySelector entitiesToFace(AIHelper helper) {
        return new OrSelector(super.entitiesToFace(helper), new ItemSelector(), new XPOrbSelector());
    }

    @Override
    protected void doInteract(Entity entityHit, AIHelper helper) {
        this.hitEntities.add(entityHit);
        helper.overrideAttack();
    }

    public boolean maxKillsReached(AIHelper helper) {
        int kills;
        return this.maxKills >= 0 && (kills = this.countKills()) >= this.maxKills;
    }

    private int countKills() {
        int kills = 0;
        for (Entity e : this.hitEntities) {
            if (!(e instanceof EntityAnimal) || !(((EntityAnimal)e).func_110143_aJ() <= 0.0f)) continue;
            ++kills;
        }
        return kills;
    }

    @Override
    public String getDescription(AIHelper helper) {
        return "Killing";
    }

    private final class KillableSelector
    implements IEntitySelector {
        private KillableSelector() {
        }

        public boolean func_82704_a(Entity e) {
            if (!KillAnimalsStrategy.this.type.hasAnimalClass(e)) {
                return false;
            }
            return ((EntityAnimal)e).func_70874_b() >= 0 && ((EntityAnimal)e).func_110143_aJ() > 0.0f;
        }
    }
}

