/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.strategy;

import java.util.ArrayList;
import java.util.List;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.ItemFilter;
import net.famzangl.minecraft.minebot.ai.animals.AnimalyType;
import net.famzangl.minecraft.minebot.ai.selectors.AndSelector;
import net.famzangl.minecraft.minebot.ai.selectors.ColorSelector;
import net.famzangl.minecraft.minebot.ai.selectors.IsSittingSelector;
import net.famzangl.minecraft.minebot.ai.selectors.NotSelector;
import net.famzangl.minecraft.minebot.ai.selectors.OneOfListSelector;
import net.famzangl.minecraft.minebot.ai.strategy.TaskStrategy;
import net.famzangl.minecraft.minebot.ai.task.FaceAndInteractTask;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;

public class LetAnimalsSitStrategy
extends TaskStrategy {
    private static final int DISTANCE = 20;
    private final int color;
    private final boolean shouldSit;
    private final List<Entity> handled = new ArrayList<Entity>();

    public LetAnimalsSitStrategy(AnimalyType wolf, boolean shouldSit, int color) {
        if (wolf != AnimalyType.WOLF) {
            throw new IllegalArgumentException();
        }
        this.shouldSit = shouldSit;
        this.color = color;
    }

    @Override
    public void searchTasks(AIHelper helper) {
        Entity found;
        if (!helper.selectCurrentItem(new NoWolfFoodFilter())) {
            return;
        }
        AndSelector selector = new AndSelector(new IsSittingSelector(!this.shouldSit, (EntityLivingBase)helper.getMinecraft().field_71439_g), new NotSelector(new OneOfListSelector(this.handled)));
        if (this.color >= 0) {
            selector = new AndSelector(selector, new ColorSelector(this.color));
        }
        if ((found = helper.getClosestEntity(20, selector)) != null) {
            this.addTask(new FaceAndInteractTask(found, selector){

                @Override
                protected void doInteractWithCurrent(AIHelper h) {
                    super.doInteractWithCurrent(h);
                    LetAnimalsSitStrategy.this.handled.add(found);
                }
            });
        }
    }

    @Override
    public String getDescription(AIHelper helper) {
        return this.shouldSit ? "Let them sit" : "Let them go";
    }

    private final class NoWolfFoodFilter
    implements ItemFilter {
        private NoWolfFoodFilter() {
        }

        @Override
        public boolean matches(ItemStack itemStack) {
            return itemStack == null || !this.interactsWithWolf(itemStack.func_77973_b());
        }

        private boolean interactsWithWolf(Item item) {
            return item instanceof ItemFood && ((ItemFood)item).func_77845_h() || item instanceof ItemDye;
        }
    }
}

