/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.strategy;

import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.path.MovePathFinder;
import net.famzangl.minecraft.minebot.ai.strategy.TaskStrategy;
import net.famzangl.minecraft.minebot.ai.task.WaitTask;

public class PathFinderStrategy
extends TaskStrategy {
    private final MovePathFinder pathFinder;
    private final String description;
    private boolean inShouldTakeOver;
    private boolean noPathFound;

    public PathFinderStrategy(MovePathFinder pathFinder, String description) {
        this.pathFinder = pathFinder;
        this.description = description;
    }

    @Override
    public void searchTasks(AIHelper helper) {
        if (!this.pathFinder.searchSomethingAround(helper.getPlayerPosition(), helper, this)) {
            if (!this.noPathFound || !this.inShouldTakeOver) {
                this.addTask(new WaitTask(1));
            }
        } else if (!this.hasMoreTasks()) {
            this.noPathFound = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkShouldTakeOver(AIHelper helper) {
        this.inShouldTakeOver = true;
        try {
            boolean bl = super.checkShouldTakeOver(helper);
            return bl;
        }
        finally {
            this.inShouldTakeOver = false;
        }
    }

    @Override
    public String getDescription(AIHelper helper) {
        return this.description;
    }

    public String toString() {
        return "PathFinderStrategy [pathFinder=" + this.pathFinder + ", description=" + this.description + "]";
    }
}

