/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.strategy;

import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.strategy.AIStrategy;
import net.famzangl.minecraft.minebot.ai.strategy.StrategyStack;

public class StackStrategy
extends AIStrategy {
    private final StrategyStack stack;
    private boolean aborted = false;

    public StackStrategy(StrategyStack stack) {
        this.stack = stack;
    }

    @Override
    protected AIStrategy.TickResult onGameTick(AIHelper helper) {
        AIStrategy.TickResult tickResult = this.stack.gameTick(helper);
        if (tickResult == AIStrategy.TickResult.ABORT) {
            this.aborted = true;
            return AIStrategy.TickResult.NO_MORE_WORK;
        }
        return tickResult;
    }

    @Override
    public boolean checkShouldTakeOver(AIHelper helper) {
        return !this.aborted && this.stack.couldTakeOver(helper);
    }

    @Override
    protected void onActivate(AIHelper helper) {
        this.stack.resume(helper);
        super.onActivate(helper);
    }

    @Override
    protected void onDeactivate(AIHelper helper) {
        this.stack.pause(helper);
        super.onDeactivate(helper);
    }

    @Override
    public String getDescription(AIHelper helper) {
        StringBuilder str = new StringBuilder("");
        AIStrategy current = this.stack.getCurrentStrategy();
        for (AIStrategy s : this.stack.getStrategies()) {
            if (str.length() != 0) {
                str.append("\n");
            }
            if (s == current && !(s instanceof StackStrategy)) {
                str.append("-> ");
            }
            str.append(s.getDescription(helper));
        }
        return str.toString();
    }
}

