/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.strategy;

import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.strategy.AIStrategy;
import net.famzangl.minecraft.minebot.ai.strategy.TimeStrategy;

public class StopInStrategy
extends TimeStrategy {
    private final int time;
    private final boolean force;

    public StopInStrategy(int seconds, boolean force) {
        this.force = force;
        this.time = seconds * 20;
    }

    @Override
    public boolean takesOverAnyTime() {
        return this.force;
    }

    @Override
    public boolean checkShouldTakeOver(AIHelper helper) {
        return this.getTimeElapsed(helper) > (long)this.time;
    }

    @Override
    protected AIStrategy.TickResult onGameTick(AIHelper helper) {
        if (this.getTimeElapsed(helper) > (long)this.time) {
            return AIStrategy.TickResult.ABORT;
        }
        return AIStrategy.TickResult.NO_MORE_WORK;
    }

    @Override
    public String getDescription(AIHelper helper) {
        int time = (int)(((long)this.time - this.getTimeElapsed(helper)) / 20L);
        return "Stop in " + time + "s";
    }
}

