/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.strategy;

import java.util.LinkedList;
import java.util.List;
import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.command.AIChatController;
import net.famzangl.minecraft.minebot.ai.path.TaskReceiver;
import net.famzangl.minecraft.minebot.ai.strategy.AIStrategy;
import net.famzangl.minecraft.minebot.ai.strategy.TaskOperations;
import net.famzangl.minecraft.minebot.ai.task.AITask;
import net.famzangl.minecraft.minebot.ai.task.CanPrefaceAndDestroy;
import net.famzangl.minecraft.minebot.ai.task.SkipWhenSearchingPrefetch;
import net.famzangl.minecraft.minebot.ai.task.error.StringTaskError;
import net.famzangl.minecraft.minebot.ai.task.error.TaskError;

public abstract class TaskStrategy
extends AIStrategy
implements TaskOperations,
TaskReceiver {
    private static final int MAX_LOOKAHEAD = 5;
    private final LinkedList<AITask> tasks = new LinkedList();
    private boolean desync;
    private boolean searchNewTasks = true;
    private AIHelper temporaryHelper;
    private final LinkedList<TaskError> lastErrors = new LinkedList();
    private int taskTimeout;

    @Override
    public void addTask(AITask task) {
        if (task == null) {
            throw new NullPointerException();
        }
        this.tasks.add(task);
    }

    @Override
    public void desync(TaskError error) {
        System.out.println("Desync. This is an error. Did the server lag?");
        System.out.println("Error: " + error);
        Thread.dumpStack();
        if (!this.lastErrors.contains(error)) {
            AIChatController.addChatLine("Error: " + error.getMessage());
        }
        if (this.lastErrors.size() > 2) {
            this.lastErrors.removeFirst();
        }
        this.lastErrors.addLast(error);
        this.desync = true;
    }

    @Override
    public boolean faceAndDestroyForNextTask() {
        boolean found = false;
        block0: for (int i = 1; i < 5 && i < this.tasks.size() && !found; ++i) {
            AITask task = this.tasks.get(i);
            if (this.tasks.get(i).getClass().isAnnotationPresent(SkipWhenSearchingPrefetch.class)) continue;
            if (!(task instanceof CanPrefaceAndDestroy)) break;
            CanPrefaceAndDestroy dTask = (CanPrefaceAndDestroy)((Object)task);
            List<Pos> positions = dTask.getPredestroyPositions(this.temporaryHelper);
            for (Pos pos : positions) {
                if (this.temporaryHelper.isAirBlock(pos.x, pos.y, pos.z)) continue;
                this.temporaryHelper.faceAndDestroy(pos.x, pos.y, pos.z);
                found = true;
                continue block0;
            }
        }
        return found;
    }

    @Override
    public boolean checkShouldTakeOver(AIHelper helper) {
        if (this.tasks.isEmpty()) {
            this.searchTasks(helper);
            this.searchNewTasks = false;
        }
        return !this.tasks.isEmpty();
    }

    @Override
    protected AIStrategy.TickResult onGameTick(AIHelper helper) {
        if (this.desync) {
            this.tasks.clear();
            this.desync = false;
            return AIStrategy.TickResult.TICK_HANDLED;
        }
        if (this.searchNewTasks) {
            this.searchTasks(helper);
            if (this.tasks.isEmpty()) {
                System.out.println("No more tasks found.");
                return AIStrategy.TickResult.NO_MORE_WORK;
            }
            this.taskTimeout = 0;
            this.searchNewTasks = false;
        } else if (this.tasks.isEmpty()) {
            this.searchNewTasks = true;
            return AIStrategy.TickResult.TICK_AGAIN;
        }
        AITask task = this.tasks.peekFirst();
        if (task.isFinished(helper)) {
            System.out.println("Task done: " + task);
            this.tasks.removeFirst();
            this.taskTimeout = 0;
            return AIStrategy.TickResult.TICK_AGAIN;
        }
        if (this.taskTimeout > task.getGameTickTimeout()) {
            this.desync(new StringTaskError("Task timed out."));
            return AIStrategy.TickResult.TICK_AGAIN;
        }
        this.temporaryHelper = helper;
        task.runTick(helper, this);
        this.temporaryHelper = null;
        ++this.taskTimeout;
        return AIStrategy.TickResult.TICK_HANDLED;
    }

    protected boolean hasMoreTasks() {
        return !this.tasks.isEmpty();
    }

    protected abstract void searchTasks(AIHelper var1);
}

