/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.strategy;

import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.ItemFilter;
import net.famzangl.minecraft.minebot.ai.selectors.AndSelector;
import net.famzangl.minecraft.minebot.ai.selectors.ColorSelector;
import net.famzangl.minecraft.minebot.ai.selectors.NotSelector;
import net.famzangl.minecraft.minebot.ai.selectors.OrSelector;
import net.famzangl.minecraft.minebot.ai.selectors.OwnTameableSelector;
import net.famzangl.minecraft.minebot.ai.strategy.TaskStrategy;
import net.famzangl.minecraft.minebot.ai.task.FaceAndInteractTask;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;

public class TintStrategy
extends TaskStrategy {
    private static final int DISTANCE = 20;
    private final int color;
    private final int current;
    private final TintType type;

    public TintStrategy(int color, TintType type, int current) {
        this.color = color;
        this.type = type;
        this.current = current;
    }

    @Override
    public void searchTasks(AIHelper helper) {
        Entity found;
        Object selector;
        if (!helper.selectCurrentItem(new DyeItemFilter(this.color))) {
            return;
        }
        EntityClientPlayerMP owner = helper.getMinecraft().field_71439_g;
        int holdingColor = 15 - owner.field_71071_by.func_70448_g().func_77960_j();
        WolfSelector wolfSelector = new WolfSelector(owner);
        SheepSelector sheepSelector = new SheepSelector();
        switch (this.type) {
            case WOLF: {
                selector = wolfSelector;
                break;
            }
            case SHEEP: {
                selector = sheepSelector;
                break;
            }
            default: {
                selector = new OrSelector(sheepSelector, wolfSelector);
            }
        }
        if (this.current >= 0) {
            selector = new AndSelector(new IEntitySelector[]{selector, new ColorSelector(this.current)});
        }
        if ((found = helper.getClosestEntity(20, (IEntitySelector)(selector = new AndSelector(new IEntitySelector[]{selector, new NotSelector(new ColorSelector(holdingColor))})))) != null) {
            this.addTask(new FaceAndInteractTask(found, (IEntitySelector)selector));
        }
    }

    @Override
    public String getDescription(AIHelper helper) {
        return "Tinting...";
    }

    public String toString() {
        return "TintStrategy [color=" + this.color + ", current=" + this.current + ", type=" + (Object)((Object)this.type) + "]";
    }

    private static class DyeItemFilter
    implements ItemFilter {
        private final int color;

        public DyeItemFilter(int color) {
            this.color = color;
        }

        @Override
        public boolean matches(ItemStack itemStack) {
            return itemStack != null && itemStack.func_77973_b() != null && itemStack.func_77973_b() instanceof ItemDye && (this.color < 0 || 15 - itemStack.func_77960_j() == this.color);
        }
    }

    public static enum TintType {
        WOLF,
        SHEEP,
        ANY;

    }

    private final class WolfSelector
    extends OwnTameableSelector {
        private WolfSelector(EntityClientPlayerMP owner) {
            super((EntityLivingBase)owner);
        }

        @Override
        public boolean func_82704_a(Entity var1) {
            return var1 instanceof EntityWolf && super.func_82704_a(var1);
        }
    }

    private final class SheepSelector
    implements IEntitySelector {
        private SheepSelector() {
        }

        public boolean func_82704_a(Entity var1) {
            return var1 instanceof EntitySheep;
        }
    }
}

