/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.strategy;

import net.famzangl.minecraft.minebot.MinebotSettings;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.commands.CommandRun;
import net.famzangl.minecraft.minebot.ai.strategy.AIStrategy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;

public abstract class ValueActionStrategy
extends AIStrategy {
    private double lastValue = -1.0;
    private final MinebotSettings settings = new MinebotSettings();
    private boolean shouldLogOut;
    private boolean shouldRunCommand;
    private boolean shouldStop;
    private static final float EPSILON = 0.01f;

    @Override
    public boolean takesOverAnyTime() {
        return true;
    }

    @Override
    public boolean checkShouldTakeOver(AIHelper helper) {
        double currentValue = this.getValue(helper);
        if (this.passedTh(this.lastValue, currentValue, this.getSetting("stop"))) {
            this.shouldStop = true;
        } else if (this.passedTh(this.lastValue, currentValue, this.getSetting("logout"))) {
            this.shouldLogOut = true;
        } else if (this.passedTh(this.lastValue, currentValue, this.getSetting("command"))) {
            this.shouldRunCommand = true;
        }
        this.lastValue = currentValue;
        return this.shouldLogOut || this.shouldStop || this.shouldRunCommand;
    }

    private boolean passedTh(double lastValue, double currentValue, double value) {
        double v = value - (double)0.01f;
        return lastValue > v && currentValue <= v;
    }

    private double getSetting(String string) {
        return this.settings.getFloat(this.getSettingPrefix() + string + "_value", -1.0f);
    }

    protected abstract double getValue(AIHelper var1);

    protected abstract String getSettingPrefix();

    @Override
    protected AIStrategy.TickResult onGameTick(AIHelper helper) {
        if (this.shouldRunCommand) {
            CommandRun.runCommand(helper, this.settings.get(this.getSettingPrefix() + "_command", ""));
            this.shouldRunCommand = false;
            return AIStrategy.TickResult.TICK_AGAIN;
        }
        if (this.shouldLogOut) {
            Minecraft mc = helper.getMinecraft();
            mc.field_71441_e.func_72882_A();
            mc.func_71403_a((WorldClient)null);
            mc.func_147108_a((GuiScreen)new GuiMainMenu());
            this.shouldLogOut = false;
            return AIStrategy.TickResult.TICK_HANDLED;
        }
        if (this.shouldStop) {
            return AIStrategy.TickResult.TICK_HANDLED;
        }
        return AIStrategy.TickResult.NO_MORE_WORK;
    }

    @Override
    public String getDescription(AIHelper helper) {
        return this.shouldStop ? "Stopped because of " + this.getSettingPrefix() + "." : "Handling " + this.getSettingPrefix() + ".";
    }
}

