/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.strategy.TaskOperations;
import net.famzangl.minecraft.minebot.ai.task.AITask;
import net.famzangl.minecraft.minebot.ai.task.CanPrefaceAndDestroy;

public class DestroyInRangeTask
extends AITask
implements CanPrefaceAndDestroy {
    private final Pos minPos;
    private final Pos maxPos;
    private int facingAttempts;
    private final ArrayList<Pos> blacklist = new ArrayList();

    public DestroyInRangeTask(Pos p1, Pos p2) {
        this.minPos = Pos.minPos(p1, p2);
        this.maxPos = Pos.maxPos(p1, p2);
    }

    private Pos getNextToDestruct(AIHelper h) {
        Pos next = null;
        double currentMin = Double.POSITIVE_INFINITY;
        for (int x = this.minPos.x; x <= this.maxPos.x; ++x) {
            for (int y = this.minPos.y; y <= this.maxPos.y; ++y) {
                for (int z = this.minPos.z; z <= this.maxPos.z; ++z) {
                    double rating = this.rate(h, x, y, z);
                    if (!(rating >= 0.0) || !(rating < currentMin)) continue;
                    next = new Pos(x, y, z);
                    currentMin = rating;
                }
            }
        }
        return next;
    }

    private double rate(AIHelper h, int x, int y, int z) {
        if (!this.isSafeToDestroy(h, x, y, z) || this.blacklist.contains(new Pos(x, y, z))) {
            return -1.0;
        }
        return h.getMinecraft().field_71439_g.func_70092_e((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
    }

    private boolean isSafeToDestroy(AIHelper h, int x, int y, int z) {
        Pos pos = h.getPlayerPosition();
        return !h.isAirBlock(x, y, z) && h.hasSafeSides(x, y, z) && (h.isSafeHeadBlock(x, y + 1, z) || (x != pos.x || y != pos.y) && this.isSafeFallingBlock(h, x, y + 1, z));
    }

    private boolean isSafeFallingBlock(AIHelper h, int x, int y, int z) {
        return AIHelper.fallingBlocks.contains(h.getBlock(x, y, z)) && this.isSafeToDestroy(h, x, y, z) || AIHelper.walkableBlocks.contains(h.getBlock(x, y, z));
    }

    @Override
    public boolean isFinished(AIHelper h) {
        return this.getNextToDestruct(h) == null;
    }

    @Override
    public void runTick(AIHelper h, TaskOperations o) {
        Pos n = this.getNextToDestruct(h);
        if (this.facingAttempts > 20) {
            this.blacklist.add(n);
            n = this.getNextToDestruct(h);
        }
        if (n != null) {
            if (h.isFacingBlock(n.x, n.y, n.z)) {
                h.faceAndDestroy(n.x, n.y, n.z);
                this.facingAttempts = 0;
            } else {
                h.faceBlock(n.x, n.y, n.z);
                ++this.facingAttempts;
            }
        }
    }

    @Override
    public int getGameTickTimeout() {
        return 100 * (Math.abs(this.minPos.x - this.maxPos.x) + 1) * (Math.abs(this.minPos.y - this.maxPos.y) + 1) * (Math.abs(this.minPos.z - this.maxPos.z) + 1);
    }

    public String toString() {
        return "DestroyInRangeTask [minPos=" + this.minPos + ", maxPos=" + this.maxPos + ", facingAttempts=" + this.facingAttempts + ", blacklist=" + this.blacklist + "]";
    }

    public void blacklist(Pos pos) {
        this.blacklist.add(pos);
    }

    @Override
    public List<Pos> getPredestroyPositions(AIHelper helper) {
        Pos next = this.getNextToDestruct(helper);
        return next != null ? Arrays.asList(next) : Collections.emptyList();
    }
}

