/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.task;

import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.strategy.TaskOperations;
import net.famzangl.minecraft.minebot.ai.task.AITask;
import net.famzangl.minecraft.minebot.ai.task.error.StringTaskError;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;

public abstract class MoveInInventoryTask
extends AITask {
    private boolean moveDone;

    protected abstract int getFromStack(AIHelper var1);

    protected abstract int getToStack(AIHelper var1);

    protected abstract int getMissingAmount(AIHelper var1, int var2);

    protected void missingItems(int missing) {
    }

    @Override
    public boolean isFinished(AIHelper h) {
        return this.moveDone;
    }

    @Override
    public void runTick(AIHelper h, TaskOperations o) {
        int missing;
        GuiContainer screen = (GuiContainer)h.getMinecraft().field_71462_r;
        if (screen == null) {
            o.desync(new StringTaskError("Expected container to be open"));
            return;
        }
        int fromStack = this.getFromStack(h);
        int toStack = this.getToStack(h);
        if (fromStack < 0 || toStack < 0 || fromStack >= screen.field_147002_h.field_75153_a.size() || toStack >= screen.field_147002_h.field_75153_a.size()) {
            System.out.println("Attempet to move : " + fromStack + " -> " + toStack);
            o.desync(new StringTaskError("Invalid item move specification."));
            return;
        }
        Slot from = screen.field_147002_h.func_75139_a(fromStack);
        if (this.getSlotContentCount(from) <= 0) {
            o.desync(new StringTaskError("Nothing in source slot."));
            return;
        }
        Slot to = screen.field_147002_h.func_75139_a(toStack);
        int amount = this.getMissingAmount(h, this.getSlotContentCount(to));
        System.out.println("Move " + amount + " from " + fromStack + " to " + toStack);
        int limit = Math.min(to.func_75219_a(), from.func_75211_c().func_77976_d());
        for (missing = Math.min(amount, limit - this.getSlotContentCount(to)); this.getSlotContentCount(from) <= missing && this.getSlotContentCount(from) > 0; missing -= this.moveAll(h, from, to)) {
        }
        System.out.println("Still missing (1): " + missing);
        while (this.getSlotContentCount(from) - this.getSlotContentCount(from) / 2 <= missing && this.getSlotContentCount(from) > 0) {
            missing -= this.moveHalf(h, from, to);
        }
        System.out.println("Still missing (2): " + missing);
        if (missing > 0 && this.getSlotContentCount(from) > 0) {
            missing -= this.moveStackPart(h, from, to, missing);
        }
        System.out.println("Still missing (3): " + missing);
        if (missing > 0) {
            this.missingItems(missing);
        }
        this.moveDone = true;
    }

    private int moveAll(AIHelper h, Slot from, Slot to) {
        return this.moveStack(h, from, to, false);
    }

    private int moveHalf(AIHelper h, Slot from, Slot to) {
        return this.moveStack(h, from, to, true);
    }

    private int moveStack(AIHelper h, Slot from, Slot to, boolean rightclickOnStart) {
        int oldCount = this.getSlotContentCount(to);
        this.click(h, from.field_75222_d, rightclickOnStart ? 1 : 0);
        this.click(h, to.field_75222_d, 0);
        return this.getSlotContentCount(to) - oldCount;
    }

    private void click(AIHelper h, int slotNumber, int i) {
        System.out.println("Click on " + slotNumber + " using " + i);
        GuiContainer screen = (GuiContainer)h.getMinecraft().field_71462_r;
        h.getMinecraft().field_71442_b.func_78753_a(screen.field_147002_h.field_75152_c, slotNumber, i, 0, (EntityPlayer)h.getMinecraft().field_71439_g);
    }

    private int moveStackPart(AIHelper h, Slot from, Slot to, int count) {
        int oldCount = this.getSlotContentCount(to);
        this.click(h, from.field_75222_d, 0);
        for (int i = 0; i < count; ++i) {
            this.click(h, to.field_75222_d, 1);
        }
        this.click(h, from.field_75222_d, 0);
        return this.getSlotContentCount(to) - oldCount;
    }

    private int getSlotContentCount(Slot slot) {
        return slot.func_75216_d() ? slot.func_75211_c().field_77994_a : 0;
    }
}

