/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.task;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.BlockItemFilter;
import net.famzangl.minecraft.minebot.ai.strategy.TaskOperations;
import net.famzangl.minecraft.minebot.ai.task.AITask;
import net.famzangl.minecraft.minebot.ai.task.SkipWhenSearchingPrefetch;
import net.famzangl.minecraft.minebot.ai.task.error.SelectTaskError;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.util.ForgeDirection;

@SkipWhenSearchingPrefetch
public class PlaceTorchSomewhereTask
extends AITask {
    private LinkedList<PosAndDir> attemptOnPositions;
    private final List<Pos> places;
    private final ForgeDirection[] preferedDirection;
    private Pos lastAttempt;

    public PlaceTorchSomewhereTask(List<Pos> positions, ForgeDirection ... preferedDirection) {
        this.places = positions;
        this.preferedDirection = preferedDirection;
    }

    @Override
    public boolean isFinished(AIHelper h) {
        PosAndDir place = this.getNextPlace(h);
        return place == null || this.lastAttempt != null && Block.func_149680_a((Block)h.getBlock(this.lastAttempt), (Block)Blocks.field_150478_aa);
    }

    private PosAndDir getNextPlace(AIHelper h) {
        if (this.attemptOnPositions == null) {
            this.attemptOnPositions = new LinkedList();
            for (Pos p : this.places) {
                for (ForgeDirection d : this.preferedDirection) {
                    PosAndDir current = new PosAndDir(p, d);
                    Pos placeOn = current.getPlaceOn();
                    if (h.isAirBlock(placeOn.x, placeOn.y, placeOn.z)) continue;
                    this.attemptOnPositions.add(current);
                }
            }
            System.out.println("Placing torch somewhere there: " + this.attemptOnPositions);
        }
        while (!this.attemptOnPositions.isEmpty() && this.attemptOnPositions.peekFirst().attemptsLeft <= 0) {
            this.attemptOnPositions.removeFirst();
        }
        return this.attemptOnPositions.peekFirst();
    }

    @Override
    public void runTick(AIHelper h, TaskOperations o) {
        BlockItemFilter f = new BlockItemFilter(Blocks.field_150478_aa);
        if (!h.selectCurrentItem(f)) {
            o.desync(new SelectTaskError(f));
        }
        PosAndDir next = this.getNextPlace(h);
        Pos placeOn = next.getPlaceOn();
        h.faceSideOf(placeOn.x, placeOn.y, placeOn.z, next.dir.getOpposite());
        if (h.isFacingBlock(placeOn.x, placeOn.y, placeOn.z, next.dir.getOpposite())) {
            h.overrideUseItem();
        }
        --next.attemptsLeft;
        this.lastAttempt = next.place;
    }

    @Override
    public int getGameTickTimeout() {
        return super.getGameTickTimeout() * 3;
    }

    public String toString() {
        return "PlaceTorchSomewhereTask [places=" + this.places + ", preferedDirection=" + Arrays.toString(this.preferedDirection) + "]";
    }

    private static class PosAndDir {
        public final Pos place;
        public final ForgeDirection dir;
        public int attemptsLeft = 10;

        public PosAndDir(Pos place, ForgeDirection dir) {
            this.place = place;
            this.dir = dir;
        }

        public Pos getPlaceOn() {
            return this.place.add(Pos.fromDir(this.dir));
        }

        public String toString() {
            return "PosAndDir [place=" + this.place + ", dir=" + this.dir + ", attemptsLeft=" + this.attemptsLeft + "]";
        }
    }
}

