/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.task;

import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.strategy.TaskOperations;
import net.famzangl.minecraft.minebot.ai.task.AITask;
import net.famzangl.minecraft.minebot.ai.task.error.StringTaskError;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;

public abstract class PutItemInContainerTask
extends AITask {
    private int slotToPlace = 0;
    private boolean placed = false;
    private boolean isFull;

    @Override
    public boolean isFinished(AIHelper h) {
        GuiContainer screen = (GuiContainer)h.getMinecraft().field_71462_r;
        return screen != null && this.placed && (this.slotToPlace < 0 || this.isFull || !screen.field_147002_h.func_75139_a(this.slotToPlace).func_75216_d());
    }

    @Override
    public void runTick(AIHelper h, TaskOperations o) {
        GuiContainer screen = (GuiContainer)h.getMinecraft().field_71462_r;
        if (screen == null) {
            o.desync(new StringTaskError("Expected container to be open"));
            return;
        }
        this.slotToPlace = this.getStackToPut(h);
        this.placed = true;
        if (this.slotToPlace < 0) {
            System.out.println("No item to put.");
            o.desync(new StringTaskError("No item to put in that slot."));
        } else {
            int oldContent;
            System.out.println("Moving from slot: " + this.slotToPlace);
            Slot slot = screen.field_147002_h.func_75139_a(this.slotToPlace);
            int newContent = this.getSlotContentCount(slot);
            do {
                oldContent = newContent;
                h.getMinecraft().field_71442_b.func_78753_a(screen.field_147002_h.field_75152_c, this.slotToPlace, 0, 1, (EntityPlayer)h.getMinecraft().field_71439_g);
            } while ((newContent = this.getSlotContentCount(slot)) != oldContent);
            if (newContent > 0) {
                this.containerIsFull();
            }
        }
    }

    protected void containerIsFull() {
        this.isFull = true;
    }

    private int getSlotContentCount(Slot slot) {
        return slot.func_75216_d() ? slot.func_75211_c().field_77994_a : 0;
    }

    protected abstract int getStackToPut(AIHelper var1);
}

