/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.task.move;

import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.strategy.TaskOperations;
import net.famzangl.minecraft.minebot.ai.task.AITask;
import net.famzangl.minecraft.minebot.ai.task.error.PositionTaskError;
import net.minecraft.init.Blocks;

public class DownwardsMoveTask
extends AITask {
    private final int x;
    private final int y;
    private final int z;
    private boolean obsidianMining;

    public DownwardsMoveTask(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public boolean isFinished(AIHelper h) {
        return h.isStandingOn(this.x, this.y, this.z);
    }

    @Override
    public void runTick(AIHelper h, TaskOperations o) {
        if (!h.isAirBlock(this.x, this.y + 1, this.z) && !h.isSideTorch(this.x, this.y + 1, this.z)) {
            h.faceAndDestroy(this.x, this.y + 1, this.z);
        } else if (!h.isAirBlock(this.x, this.y, this.z)) {
            if (!h.isStandingOn(this.x, this.y + 1, this.z)) {
                System.out.println("Not standing on the right block.");
                o.desync(new PositionTaskError(this.x, this.y + 1, this.z));
            }
            if (AIHelper.blockIsOneOf(h.getBlock(this.x, this.y, this.z), Blocks.field_150343_Z)) {
                this.obsidianMining = true;
            }
            h.faceAndDestroy(this.x, this.y, this.z);
        }
    }

    @Override
    public int getGameTickTimeout() {
        return super.getGameTickTimeout() + (this.obsidianMining ? 200 : 0);
    }

    public String toString() {
        return "DownwardsMoveTask [x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }
}

