/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.task.place;

import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.ItemFilter;
import net.famzangl.minecraft.minebot.ai.strategy.TaskOperations;
import net.famzangl.minecraft.minebot.ai.task.AITask;
import net.famzangl.minecraft.minebot.ai.task.error.SelectTaskError;
import net.minecraftforge.common.util.ForgeDirection;

public class PlaceBlockAtFloorTask
extends AITask {
    protected int x;
    protected int y;
    protected int z;
    private final ItemFilter filter;
    private int faceTimer;

    public PlaceBlockAtFloorTask(int x, int y, int z, ItemFilter filter) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.filter = filter;
    }

    protected int getPlaceAtY() {
        return this.y;
    }

    @Override
    public boolean isFinished(AIHelper h) {
        return !h.isAirBlock(this.x, this.getPlaceAtY(), this.z);
    }

    @Override
    public void runTick(AIHelper h, TaskOperations o) {
        if (this.faceTimer > 0) {
            --this.faceTimer;
        }
        if (h.isAirBlock(this.x, this.getPlaceAtY(), this.z)) {
            if (!h.selectCurrentItem(this.filter)) {
                o.desync(new SelectTaskError(this.filter));
            } else if (this.faceTimer == 0) {
                this.faceBlock(h, o);
                this.faceTimer = 2;
            } else {
                this.tryPlaceBlock(h);
            }
        }
    }

    protected void faceBlock(AIHelper h, TaskOperations o) {
        h.faceSideOf(this.x, this.getPlaceAtY() - 1, this.z, ForgeDirection.UP);
    }

    protected void tryPlaceBlock(AIHelper h) {
        if (h.getMinecraft().field_71439_g.field_70121_D.field_72338_b >= (double)this.getPlaceAtY() && this.isFacingRightBlock(h)) {
            h.overrideUseItem();
        }
    }

    protected boolean isFacingRightBlock(AIHelper h) {
        return h.isFacingBlock(this.x, this.getPlaceAtY() - 1, this.z, ForgeDirection.UP);
    }

    public String toString() {
        return "UpwardsMoveTask [x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }
}

