/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.build;

import java.util.LinkedList;
import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.BlockItemFilter;
import net.famzangl.minecraft.minebot.ai.strategy.TaskOperations;
import net.famzangl.minecraft.minebot.ai.task.AITask;
import net.famzangl.minecraft.minebot.ai.task.error.SelectTaskError;
import net.minecraft.init.Blocks;
import net.minecraft.util.MovementInput;

public class WalkTowardsTask
extends AITask {
    private static final BlockItemFilter CARPET = new BlockItemFilter(Blocks.field_150404_cg);
    private final Pos fromPos;
    private final Pos nextPos;
    private AITask subTask;
    private final LinkedList<Pos> carpets = new LinkedList();
    private boolean wasStandingOnDest;

    public WalkTowardsTask(Pos fromPos, Pos nextPos) {
        this.fromPos = fromPos;
        this.nextPos = nextPos;
    }

    @Override
    public boolean isFinished(AIHelper h) {
        return this.subTask == null && h.isStandingOn(this.nextPos.x, this.nextPos.y, this.nextPos.z) && this.carpets.isEmpty();
    }

    @Override
    public void runTick(AIHelper h, TaskOperations o) {
        if (this.subTask != null && this.subTask.isFinished(h)) {
            this.subTask = null;
        }
        if (this.subTask != null) {
            this.subTask.runTick(h, o);
        } else {
            double destHeight;
            int carpetY = this.getUpperCarpetY(h);
            double carpetBuildHeight = h.realBlockTopY(this.fromPos.x, Math.max(carpetY + 1, this.fromPos.y), this.fromPos.z);
            if (carpetBuildHeight < (destHeight = h.realBlockTopY(this.nextPos.x, this.nextPos.y, this.nextPos.z)) - 1.0) {
                System.out.println("Moving upwards. Carpets are at " + carpetY);
                int floorY = Math.max(carpetY, this.fromPos.y - 1);
                h.faceBlock(this.fromPos.x, floorY, this.fromPos.z);
                if (h.isFacingBlock(this.fromPos.x, floorY, this.fromPos.z, 1)) {
                    if (h.selectCurrentItem(CARPET)) {
                        h.overrideUseItem();
                        this.carpets.add(new Pos(this.fromPos.x, floorY + 1, this.fromPos.z));
                    } else {
                        o.desync(new SelectTaskError(CARPET));
                    }
                }
                MovementInput i = new MovementInput();
                i.field_78901_c = true;
                h.overrideMovement(i);
            } else if ((h.isStandingOn(this.nextPos.x, this.nextPos.y, this.nextPos.z) || this.wasStandingOnDest) && !this.carpets.isEmpty()) {
                while (!this.carpets.isEmpty()) {
                    Pos last = this.carpets.getLast();
                    if (!h.isAirBlock(last.x, last.y, last.z)) continue;
                    this.carpets.removeLast();
                }
                int x = this.fromPos.x - this.nextPos.x;
                int z = this.fromPos.x - this.nextPos.x;
                if (h.sneakFrom(this.nextPos.x, this.nextPos.y, this.nextPos.z, AIHelper.getDirectionForXZ(x, z))) {
                    Pos last = this.carpets.getLast();
                    h.faceAndDestroy(last.x, last.y, last.z);
                }
                this.wasStandingOnDest = true;
            } else {
                h.walkTowards((double)this.nextPos.x + 0.5, (double)this.nextPos.z + 0.5, carpetBuildHeight < destHeight - 0.5);
            }
        }
    }

    private int getUpperCarpetY(AIHelper h) {
        int y;
        int upperCarpet = -1;
        int n = y = AIHelper.blockIsOneOf(h.getBlock(this.fromPos), Blocks.field_150350_a, Blocks.field_150404_cg) ? this.fromPos.y : this.fromPos.y + 1;
        while (y < this.nextPos.y && AIHelper.blockIsOneOf(h.getBlock(this.fromPos.x, y, this.fromPos.z), Blocks.field_150404_cg)) {
            upperCarpet = y++;
        }
        return upperCarpet;
    }

    public String toString() {
        return "WalkTowardsTask [currentPos=" + this.fromPos + ", nextPos=" + this.nextPos + ", subTask=" + this.subTask + "]";
    }
}

