/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.build.blockbuild;

import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.task.AITask;
import net.famzangl.minecraft.minebot.ai.task.BlockSide;
import net.famzangl.minecraft.minebot.ai.task.place.JumpingPlaceAtHalfTask;
import net.famzangl.minecraft.minebot.ai.task.place.SneakAndPlaceAtHalfTask;
import net.famzangl.minecraft.minebot.build.blockbuild.BuildTask;
import net.famzangl.minecraft.minebot.build.blockbuild.CubeBuildTask;
import net.famzangl.minecraft.minebot.build.blockbuild.MirrorDirection;
import net.famzangl.minecraft.minebot.build.blockbuild.SlabFilter;
import net.famzangl.minecraft.minebot.build.blockbuild.SlabType;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class BuildHalfslabTask
extends CubeBuildTask {
    public static final Block[] BLOCKS = new Block[]{Blocks.field_150333_U, Blocks.field_150376_bx};
    private final BlockSide side;
    private final SlabType slabType;

    public BuildHalfslabTask(Pos forPosition, SlabType slabType, BlockSide up) {
        super(forPosition, new SlabFilter(slabType));
        this.slabType = slabType;
        this.side = up;
    }

    @Override
    public AITask getPlaceBlockTask(Pos relativeFromPos) {
        if (!this.isStandablePlace(relativeFromPos)) {
            throw new IllegalArgumentException("Cannot build standing there: " + relativeFromPos);
        }
        if (relativeFromPos.equals(FROM_GROUND)) {
            return new JumpingPlaceAtHalfTask(this.forPosition.x, this.forPosition.y + 1, this.forPosition.z, this.blockFilter, this.side);
        }
        return new SneakAndPlaceAtHalfTask(this.forPosition.x, this.forPosition.y + 1, this.forPosition.z, this.blockFilter, relativeFromPos, this.getMinHeightToBuild(), this.side);
    }

    @Override
    protected double getBlockHeight() {
        return this.side == BlockSide.LOWER_HALF ? 0.5 : 1.0;
    }

    public String toString() {
        return "BuildHalfslabTask [side=" + (Object)((Object)this.side) + ", blockFilter=" + this.blockFilter + ", forPosition=" + this.forPosition + "]";
    }

    @Override
    public BuildTask withPositionAndRotation(Pos add, int rotateSteps, MirrorDirection mirror) {
        return new BuildHalfslabTask(add, this.slabType, this.side);
    }
}

