/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.build.blockbuild;

import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.ColoredBlockItemFilter;
import net.famzangl.minecraft.minebot.ai.ItemFilter;
import net.famzangl.minecraft.minebot.ai.task.AITask;
import net.famzangl.minecraft.minebot.ai.task.place.JumpingPlaceAtHalfTask;
import net.famzangl.minecraft.minebot.build.WoodType;
import net.famzangl.minecraft.minebot.build.blockbuild.BlockBuildTask;
import net.famzangl.minecraft.minebot.build.blockbuild.BuildHalfslabTask;
import net.famzangl.minecraft.minebot.build.blockbuild.BuildNormalStairsTask;
import net.famzangl.minecraft.minebot.build.blockbuild.ColoredCubeBuildTask;
import net.famzangl.minecraft.minebot.build.blockbuild.CubeBuildTask;
import net.famzangl.minecraft.minebot.build.blockbuild.FenceBuildTask;
import net.famzangl.minecraft.minebot.build.blockbuild.LogBuildTask;
import net.famzangl.minecraft.minebot.build.blockbuild.MirrorDirection;
import net.famzangl.minecraft.minebot.build.blockbuild.SlabType;
import net.famzangl.minecraft.minebot.build.blockbuild.TaskDescription;
import net.famzangl.minecraft.minebot.build.blockbuild.UnknownBlockException;
import net.famzangl.minecraft.minebot.build.blockbuild.WoodBuildTask;
import net.minecraft.block.Block;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BuildTask {
    protected final Pos forPosition;

    protected BuildTask(Pos forPosition) {
        this.forPosition = forPosition;
    }

    public static TaskDescription getTaskDescription(Block b, AIHelper h, int x, int y, int z) throws UnknownBlockException {
        String name = Block.field_149771_c.func_148750_c((Object)b).replaceFirst("minecraft:", "");
        int blockMetadata = h.getMinecraft().field_71441_e.func_72805_g(x, y, z);
        if (AIHelper.blockIsOneOf(b, BlockBuildTask.BLOCKS)) {
            return new TaskDescription(name, CubeBuildTask.STANDABLE);
        }
        if (AIHelper.blockIsOneOf(b, ColoredCubeBuildTask.BLOCKS)) {
            return new TaskDescription(name + " " + ColoredBlockItemFilter.COLORS[blockMetadata], CubeBuildTask.STANDABLE);
        }
        if (AIHelper.blockIsOneOf(b, FenceBuildTask.BLOCKS)) {
            return new TaskDescription(name, FenceBuildTask.STANDABLE);
        }
        if (AIHelper.blockIsOneOf(b, LogBuildTask.BLOCKS)) {
            for (WoodType t : WoodType.values()) {
                Pos[] pos;
                String dir;
                if (t.lowerBits != (blockMetadata & 3) || t.block != b) continue;
                if ((blockMetadata & 0xC) == 4) {
                    dir = "east";
                    pos = LogBuildTask.EAST_WEST_POS;
                } else if ((blockMetadata & 0xC) == 8) {
                    dir = "north";
                    pos = LogBuildTask.NORTH_SOUTH_POS;
                } else {
                    dir = "up";
                    pos = LogBuildTask.UP_DOWN_POS;
                }
                return new TaskDescription(name + " " + t.toString().toLowerCase() + " " + dir, pos);
            }
            throw new UnknownBlockException("Unknown wood type " + b);
        }
        if (AIHelper.blockIsOneOf(b, WoodBuildTask.BLOCK)) {
            return new TaskDescription(name + " " + WoodType.values()[blockMetadata].toString().toLowerCase(), CubeBuildTask.STANDABLE);
        }
        if (AIHelper.blockIsOneOf(b, BuildNormalStairsTask.BLOCKS)) {
            Pos[] standable;
            String up;
            ForgeDirection dir;
            switch (blockMetadata & 3) {
                case 0: {
                    dir = ForgeDirection.WEST;
                    break;
                }
                case 1: {
                    dir = ForgeDirection.EAST;
                    break;
                }
                case 2: {
                    dir = ForgeDirection.NORTH;
                    break;
                }
                default: {
                    dir = ForgeDirection.SOUTH;
                }
            }
            Pos p1 = Pos.fromDir(dir.getOpposite()).add(0, 1, 0);
            Pos p2 = Pos.fromDir(dir.getRotation(ForgeDirection.UP)).add(0, 1, 0);
            Pos p3 = Pos.fromDir(dir.getRotation(ForgeDirection.DOWN)).add(0, 1, 0);
            if ((blockMetadata & 4) == 0) {
                up = "lower";
                standable = new Pos[]{new Pos(0, 0, 0), p1, p2, p3};
            } else {
                up = "upper";
                standable = new Pos[]{p1, p2, p3};
            }
            return new TaskDescription(name + " " + dir.toString().toLowerCase() + " " + up, standable);
        }
        if (AIHelper.blockIsOneOf(b, BuildHalfslabTask.BLOCKS)) {
            for (SlabType t : SlabType.values()) {
                ForgeDirection[] standable;
                BuildNormalStairsTask.Half up;
                if (t.slabBlock != b || t.meta != (blockMetadata & 7)) continue;
                if ((blockMetadata & 8) == 0) {
                    up = BuildNormalStairsTask.Half.LOWER;
                    standable = JumpingPlaceAtHalfTask.TRY_FOR_LOWER;
                } else {
                    up = BuildNormalStairsTask.Half.UPPER;
                    standable = JumpingPlaceAtHalfTask.TRY_FOR_UPPER;
                }
                return new TaskDescription(name + " " + t.toString().toLowerCase() + " " + up.toString().toLowerCase(), Pos.fromDir(standable));
            }
            throw new UnknownBlockException("Cannot find halfslabs " + b);
        }
        throw new UnknownBlockException("Cannot reverse build task for " + b);
    }

    public abstract Pos[] getStandablePlaces();

    public Pos getForPosition() {
        return this.forPosition;
    }

    public abstract AITask getPlaceBlockTask(Pos var1);

    public boolean isStandablePlace(Pos relativeFromPos) {
        for (Pos p : this.getStandablePlaces()) {
            if (!p.equals(relativeFromPos)) continue;
            return true;
        }
        return false;
    }

    public boolean couldBuildFrom(AIHelper helper, int x, int y, int z) {
        Pos pos = this.getForPosition();
        for (Pos p : this.getStandablePlaces()) {
            if (p.x + pos.x != x || p.y + pos.y != y || p.z + pos.z != z) continue;
            return true;
        }
        return false;
    }

    public abstract ItemFilter getRequiredItem();

    public abstract BuildTask withPositionAndRotation(Pos var1, int var2, MirrorDirection var3);
}

