/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.build.blockbuild;

import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.BlockItemFilter;
import net.famzangl.minecraft.minebot.build.LogItemFilter;
import net.famzangl.minecraft.minebot.build.WoodType;
import net.famzangl.minecraft.minebot.build.blockbuild.BuildTask;
import net.famzangl.minecraft.minebot.build.blockbuild.CubeBuildTask;
import net.famzangl.minecraft.minebot.build.blockbuild.MirrorDirection;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.util.ForgeDirection;

public class LogBuildTask
extends CubeBuildTask {
    public static final Block[] BLOCKS = new Block[]{Blocks.field_150364_r, Blocks.field_150363_s};
    public static final Pos[] UP_DOWN_POS = new Pos[]{new Pos(0, 0, 0)};
    public static final Pos[] NORTH_SOUTH_POS = new Pos[]{new Pos(0, 1, 1), new Pos(0, 1, -1)};
    public static final Pos[] EAST_WEST_POS = new Pos[]{new Pos(1, 1, 0), new Pos(-1, 1, 0)};
    private final ForgeDirection dir;

    public LogBuildTask(Pos forPosition, WoodType logType, ForgeDirection direction) {
        this(forPosition, new LogItemFilter(logType), direction);
    }

    private LogBuildTask(Pos forPosition, BlockItemFilter logItemFilter, ForgeDirection direction) {
        super(forPosition, logItemFilter);
        this.dir = direction;
    }

    @Override
    public Pos[] getStandablePlaces() {
        switch (this.dir) {
            case EAST: 
            case WEST: {
                return EAST_WEST_POS;
            }
            case SOUTH: 
            case NORTH: {
                return NORTH_SOUTH_POS;
            }
        }
        return UP_DOWN_POS;
    }

    @Override
    public BuildTask withPositionAndRotation(Pos add, int rotateSteps, MirrorDirection mirror) {
        ForgeDirection newDir = this.dir;
        for (int i = 0; i < rotateSteps; ++i) {
            newDir = newDir.getRotation(ForgeDirection.UP);
        }
        return new LogBuildTask(add, this.blockFilter, newDir);
    }
}

