/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.build.commands;

import java.util.List;
import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.command.AIChatController;
import net.famzangl.minecraft.minebot.ai.command.AICommand;
import net.famzangl.minecraft.minebot.ai.command.AICommandInvocation;
import net.famzangl.minecraft.minebot.ai.command.AICommandParameter;
import net.famzangl.minecraft.minebot.ai.command.ParameterType;
import net.famzangl.minecraft.minebot.ai.command.SafeStrategyRule;
import net.famzangl.minecraft.minebot.ai.render.MarkingStrategy;
import net.famzangl.minecraft.minebot.ai.render.PosMarkerRenderer;
import net.famzangl.minecraft.minebot.ai.strategy.AIStrategy;
import net.famzangl.minecraft.minebot.ai.strategy.TaskStrategy;
import net.famzangl.minecraft.minebot.ai.task.GetOnHotBarTask;
import net.famzangl.minecraft.minebot.ai.task.WaitTask;
import net.famzangl.minecraft.minebot.ai.task.move.AlignToGridTask;
import net.famzangl.minecraft.minebot.build.ForBuildPathFinder;
import net.famzangl.minecraft.minebot.build.NextTaskTask;
import net.famzangl.minecraft.minebot.build.blockbuild.BuildTask;
import net.minecraftforge.client.event.RenderWorldLastEvent;

@AICommand(helpText="Runs all tasks that are scheduled for building.", name="minebuild")
public class CommandBuild {
    @AICommandInvocation(safeRule=SafeStrategyRule.DEFEND)
    public static AIStrategy run(AIHelper helper, @AICommandParameter(type=ParameterType.FIXED, fixedName="build", description="") String nameArg2) {
        return new BuildStrategy();
    }

    public static Pos isAroundSite(AIHelper helper, BuildTask task) {
        Pos forPosition = task.getForPosition();
        for (Pos p : task.getStandablePlaces()) {
            int x = p.x + forPosition.x;
            int y = p.y + forPosition.y;
            int z = p.z + forPosition.z;
            System.out.println("Check " + forPosition + " + " + p + " -> " + helper.isStandingOn(x, y, z) + ", " + task.couldBuildFrom(helper, x, y, z));
            if (!helper.isStandingOn(x, y, z) || !task.couldBuildFrom(helper, x, y, z)) continue;
            return p;
        }
        return null;
    }

    private static final class BuildStrategy
    extends TaskStrategy
    implements MarkingStrategy {
        private boolean alignSend;
        private ForBuildPathFinder pathFinder;
        private final PosMarkerRenderer renderer = new PosMarkerRenderer(1.0f, 1.0f, 0.0f);
        private final Pos[] positions = new Pos[5];

        private BuildStrategy() {
        }

        @Override
        public void searchTasks(AIHelper helper) {
            BuildTask task = helper.buildManager.peekNextTask();
            if (task == null) {
                AIChatController.addChatLine("No more build tasks.");
            } else if (!this.alignSend) {
                this.addTask(new AlignToGridTask(helper.getPlayerPosition()));
                this.alignSend = true;
            } else {
                Pos pos = CommandBuild.isAroundSite(helper, task);
                if (pos == null) {
                    if (this.pathFinder == null) {
                        this.pathFinder = new ForBuildPathFinder(task);
                    }
                    if (!this.pathFinder.searchSomethingAround(helper.getPlayerPosition(), helper, this)) {
                        this.addTask(new WaitTask());
                    } else if (this.pathFinder.isNoPathFound()) {
                        AIChatController.addChatLine("Cannot navigate to next build task.");
                    }
                } else {
                    this.addTask(new GetOnHotBarTask(task.getRequiredItem()));
                    this.addTask(task.getPlaceBlockTask(pos));
                    this.addTask(new NextTaskTask());
                    this.alignSend = false;
                    this.pathFinder = null;
                }
            }
            this.reloadPositions(helper.buildManager.getScheduled());
        }

        private void reloadPositions(List<BuildTask> list) {
            for (int i = 0; i < this.positions.length; ++i) {
                this.positions[i] = i < list.size() ? list.get(i).getForPosition() : null;
            }
        }

        @Override
        public String getDescription(AIHelper helper) {
            return "Building.";
        }

        @Override
        public void drawMarkers(RenderWorldLastEvent event, AIHelper helper) {
            this.renderer.render(event, helper, this.positions);
        }
    }
}

