/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.build.commands;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.HumanReadableItemFilter;
import net.famzangl.minecraft.minebot.ai.ItemFilter;
import net.famzangl.minecraft.minebot.ai.command.AIChatController;
import net.famzangl.minecraft.minebot.ai.command.AICommand;
import net.famzangl.minecraft.minebot.ai.command.AICommandInvocation;
import net.famzangl.minecraft.minebot.ai.command.AICommandParameter;
import net.famzangl.minecraft.minebot.ai.command.ParameterType;
import net.famzangl.minecraft.minebot.ai.strategy.AIStrategy;
import net.famzangl.minecraft.minebot.build.blockbuild.BuildTask;

@AICommand(helpText="Count all stuff required for building.", name="minebuild")
public class CommandCount {
    @AICommandInvocation
    public static AIStrategy run(AIHelper helper, @AICommandParameter(type=ParameterType.FIXED, fixedName="count", description="") String nameArg2) {
        Hashtable<ItemFilter, Integer> counts = new Hashtable<ItemFilter, Integer>();
        for (BuildTask s : helper.buildManager.getScheduled()) {
            ItemFilter required;
            Integer count = (Integer)counts.get(required = s.getRequiredItem());
            counts.put(required, count == null ? 1 : count + 1);
        }
        ArrayList list = new ArrayList(counts.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<ItemFilter, Integer>>(){

            @Override
            public int compare(Map.Entry<ItemFilter, Integer> o1, Map.Entry<ItemFilter, Integer> o2) {
                return -o1.getValue().compareTo(o2.getValue());
            }
        });
        AIChatController.addToChatPaged("Required items", 1, list, new Function<Map.Entry<ItemFilter, Integer>, String>(){

            public String apply(Map.Entry<ItemFilter, Integer> item) {
                ItemFilter filter = item.getKey();
                String key = CommandCount.niceFilterName(filter);
                return key + ": " + item.getValue();
            }
        });
        return null;
    }

    public static String niceFilterName(ItemFilter filter) {
        return filter instanceof HumanReadableItemFilter ? ((HumanReadableItemFilter)filter).getDescription() : filter.toString();
    }
}

