/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.build.commands;

import java.util.ArrayList;
import java.util.List;
import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.command.AICommand;
import net.famzangl.minecraft.minebot.ai.command.AICommandInvocation;
import net.famzangl.minecraft.minebot.ai.command.AICommandParameter;
import net.famzangl.minecraft.minebot.ai.command.ParameterType;
import net.famzangl.minecraft.minebot.ai.strategy.AIStrategy;
import net.famzangl.minecraft.minebot.build.blockbuild.BuildTask;
import net.famzangl.minecraft.minebot.build.blockbuild.MirrorDirection;
import net.minecraftforge.common.util.ForgeDirection;

@AICommand(helpText="Move everything that is scheduled in the direction you are looking / given", name="minebuild")
public class CommandMove {
    @AICommandInvocation
    public static AIStrategy run(AIHelper helper, @AICommandParameter(type=ParameterType.FIXED, fixedName="move", description="") String nameArg, @AICommandParameter(type=ParameterType.NUMBER, fixedName="", description="How much") int howMuch) {
        return CommandMove.run(helper, nameArg, helper.getLookDirection(), howMuch);
    }

    @AICommandInvocation
    public static AIStrategy run(AIHelper helper, @AICommandParameter(type=ParameterType.FIXED, fixedName="move", description="") String nameArg, @AICommandParameter(type=ParameterType.ENUM, fixedName="", description="Direction") ForgeDirection dir, @AICommandParameter(type=ParameterType.NUMBER, fixedName="", description="How much") int howMuch) {
        return new MoveStrategy(Pos.fromDir(dir).multiply(howMuch), null, null);
    }

    @AICommandInvocation
    public static AIStrategy run(AIHelper helper, @AICommandParameter(type=ParameterType.FIXED, fixedName="mirror", description="") String nameArg, @AICommandParameter(type=ParameterType.ENUM, fixedName="", description="Direction") MirrorDirection dir) {
        return new MoveStrategy(new Pos(0, 0, 0), null, dir);
    }

    @AICommandInvocation
    public static AIStrategy run(AIHelper helper, @AICommandParameter(type=ParameterType.FIXED, fixedName="rotate", description="") String nameArg, @AICommandParameter(type=ParameterType.ENUM, fixedName="", description="Direction") Rotate dir) {
        return new MoveStrategy(new Pos(0, 0, 0), dir, null);
    }

    public static enum Rotate {
        CLOCKWISE(1),
        COUNTERCLOCKWISE(3),
        HALF(2);

        public final int r;

        private Rotate(int r) {
            this.r = r;
        }

        public Pos apply(Pos current) {
            switch (this) {
                case CLOCKWISE: {
                    return new Pos(-current.z, current.y, current.x);
                }
                case COUNTERCLOCKWISE: {
                    return new Pos(current.z, current.y, -current.x);
                }
                case HALF: {
                    return new Pos(-current.x, current.y, -current.z);
                }
            }
            return current;
        }
    }

    private static final class MoveStrategy
    extends AIStrategy {
        private final Pos relative;
        private final Rotate rotate;
        private final MirrorDirection mirror;
        private boolean moved;

        private MoveStrategy(Pos relative, Rotate rotate, MirrorDirection mirror) {
            this.relative = relative;
            this.rotate = rotate;
            this.mirror = mirror;
        }

        @Override
        public boolean checkShouldTakeOver(AIHelper helper) {
            return !this.moved;
        }

        @Override
        protected AIStrategy.TickResult onGameTick(AIHelper helper) {
            if (!this.moved) {
                ArrayList<BuildTask> tasks = new ArrayList<BuildTask>();
                Pos center = this.getCenter(helper.buildManager.getScheduled());
                while (helper.buildManager.peekNextTask() != null) {
                    BuildTask next = helper.buildManager.popNextTask();
                    Pos nextPos = next.getForPosition().add(this.relative);
                    if (this.rotate != null) {
                        nextPos = this.rotate.apply(nextPos.subtract(center)).add(center);
                    }
                    if (this.mirror == MirrorDirection.EAST_WEST) {
                        nextPos = new Pos(center.x * 2 - nextPos.x, nextPos.y, nextPos.z);
                    } else if (this.mirror == MirrorDirection.NORTH_SOUTH) {
                        nextPos = new Pos(nextPos.x, nextPos.y, center.z * 2 - nextPos.z);
                    }
                    BuildTask task = next.withPositionAndRotation(nextPos, this.rotate == null ? 0 : this.rotate.r, this.mirror);
                    tasks.add(task);
                }
                for (BuildTask task : tasks) {
                    helper.buildManager.addTask(task);
                }
                this.moved = true;
            }
            return AIStrategy.TickResult.NO_MORE_WORK;
        }

        private Pos getCenter(List<BuildTask> scheduled) {
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            for (BuildTask s : scheduled) {
                Pos pos = s.getForPosition();
                x += (double)pos.x;
                y += (double)pos.y;
                z += (double)pos.z;
            }
            int c = Math.max(1, scheduled.size());
            return new Pos((int)(x / (double)c), (int)(y / (double)c), (int)(z / (double)c));
        }

        @Override
        public String getDescription(AIHelper helper) {
            return null;
        }
    }
}

