/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.build.reverse;

import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.command.AIChatController;
import net.famzangl.minecraft.minebot.ai.strategy.AIStrategy;
import net.famzangl.minecraft.minebot.build.reverse.BuildReverser;

public final class RunReverseBuildStrategy
extends AIStrategy {
    final String outFile;
    private boolean done = false;

    public RunReverseBuildStrategy(String outFile) {
        this.outFile = outFile;
    }

    @Override
    public boolean checkShouldTakeOver(AIHelper helper) {
        return !this.done;
    }

    @Override
    protected AIStrategy.TickResult onGameTick(AIHelper helper) {
        if (!this.done) {
            if (helper.getPos1() == null || helper.getPos2() == null) {
                AIChatController.addChatLine("Set positions first.");
            } else {
                new BuildReverser(helper, this.outFile).run();
            }
            this.done = true;
        }
        return AIStrategy.TickResult.NO_MORE_WORK;
    }

    @Override
    public String getDescription(AIHelper helper) {
        return "Generating build tasks.";
    }

    public String toString() {
        return "RunReverseBuildStrategy [outFile=" + this.outFile + "]";
    }
}

