/*
 * Decompiled with CFR 0.152.
 */
package com.llamalad7.mixinextras.sugar.impl;

import com.llamalad7.mixinextras.injector.StackExtension;
import com.llamalad7.mixinextras.sugar.impl.SugarApplicationException;
import com.llamalad7.mixinextras.sugar.impl.SugarApplicator;
import com.llamalad7.mixinextras.sugar.impl.SugarParameter;
import com.llamalad7.mixinextras.sugar.impl.ref.LocalRefUtils;
import com.llamalad7.mixinextras.utils.ASMUtils;
import com.llamalad7.mixinextras.utils.TargetDecorations;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LocalVariableNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Annotations;

class ShareSugarApplicator
extends SugarApplicator {
    private final String id;
    private Type innerType;

    ShareSugarApplicator(InjectionInfo info, SugarParameter parameter) {
        super(info, parameter);
        this.id = this.mixin.getClassRef() + ':' + Annotations.getValue(this.sugar);
    }

    @Override
    void validate(Target target, InjectionNodes.InjectionNode node) {
        this.innerType = LocalRefUtils.getTargetType(this.paramType, Type.getType(Object.class));
        if (this.innerType == this.paramType) {
            throw new SugarApplicationException("@Share parameter must be some variation of LocalRef.");
        }
    }

    @Override
    void prepare(Target target, InjectionNodes.InjectionNode node) {
    }

    @Override
    void inject(Target target, InjectionNodes.InjectionNode node, StackExtension stack) {
        int localRefIndex;
        Map refIndices = TargetDecorations.getOrPut(target, "ShareSugar_LocalRefIndices", HashMap::new);
        if (!refIndices.containsKey(this.id)) {
            localRefIndex = target.allocateLocal();
            refIndices.put(this.id, localRefIndex);
            LabelNode start = new LabelNode();
            LabelNode end = new LabelNode();
            target.addLocalVariable(localRefIndex, "sharedRef" + localRefIndex, this.paramType.getDescriptor());
            List<LocalVariableNode> lvt = target.method.localVariables;
            LocalVariableNode newVar = lvt.get(lvt.size() - 1);
            newVar.start = start;
            newVar.end = end;
            target.insns.insert(start);
            target.insns.add(end);
            InsnList init = new InsnList();
            LocalRefUtils.generateNew(init, this.innerType);
            init.add(new VarInsnNode(58, localRefIndex));
            init.add(new VarInsnNode(25, localRefIndex));
            init.add(new InsnNode(ASMUtils.getDummyOpcodeForType(this.innerType)));
            LocalRefUtils.generateInitialization(init, this.innerType);
            target.insns.insert((AbstractInsnNode)start, init);
            stack.ensureAtLeast(this.innerType.getSize() + 1);
        } else {
            localRefIndex = (Integer)refIndices.get(this.id);
        }
        stack.extra(1);
        target.insns.insertBefore(node.getCurrentTarget(), new VarInsnNode(25, localRefIndex));
    }
}

