/*
 * Decompiled with CFR 0.152.
 */
package riskyken.armourersWorkshop.common.crafting.recipe;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import riskyken.armourersWorkshop.api.common.skin.type.ISkinType;
import riskyken.armourersWorkshop.common.crafting.recipe.RecipeItemSkinning;
import riskyken.armourersWorkshop.common.skin.data.SkinPointer;
import riskyken.armourersWorkshop.utils.SkinNBTHelper;

public class RecipeSkinArmour
extends RecipeItemSkinning {
    public RecipeSkinArmour(ISkinType skinType) {
        super(skinType);
    }

    @Override
    public boolean matches(IInventory inventory) {
        return this.getCraftingResult(inventory) != null;
    }

    @Override
    public ItemStack getCraftingResult(IInventory inventory) {
        ItemStack skinStack = null;
        ItemStack armourStack = null;
        for (int slotId = 0; slotId < inventory.func_70302_i_(); ++slotId) {
            ItemStack stack = inventory.func_70301_a(slotId);
            if (stack == null) continue;
            Item item = stack.func_77973_b();
            if (this.isValidSkinForType(stack)) {
                if (skinStack != null) {
                    return null;
                }
                skinStack = stack;
                continue;
            }
            if (this.isValidArmour(stack) & !SkinNBTHelper.isSkinLockedOnStack(stack)) {
                if (armourStack != null) {
                    return null;
                }
                armourStack = stack;
                continue;
            }
            return null;
        }
        if (skinStack != null && armourStack != null) {
            if (!this.isValidArmourForSkin(armourStack, skinStack)) {
                return null;
            }
            ItemStack returnStack = armourStack.func_77946_l();
            SkinPointer skinData = SkinNBTHelper.getSkinPointerFromStack(skinStack);
            SkinNBTHelper.addSkinDataToStack(returnStack, skinData.getIdentifier(), skinData.getSkinDye(), true);
            return returnStack;
        }
        return null;
    }

    private boolean isValidArmour(ItemStack stack) {
        Item item = stack.func_77973_b();
        for (int i = 0; i < 4; ++i) {
            if (!item.isValidArmor(stack, i, null)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidArmourForSkin(ItemStack armourStack, ItemStack skinStack) {
        SkinPointer sp = SkinNBTHelper.getSkinPointerFromStack(skinStack);
        ISkinType skinType = sp.getIdentifier().getSkinType();
        Item armourItem = armourStack.func_77973_b();
        return armourItem.isValidArmor(armourStack, skinType.getVanillaArmourSlotId(), null);
    }

    @Override
    public void onCraft(IInventory inventory) {
        for (int slotId = 0; slotId < inventory.func_70302_i_(); ++slotId) {
            inventory.func_70298_a(slotId, 1);
        }
    }
}

