/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEditableBook;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.blocks.tiles.TileBigSign;
import noppes.npcs.blocks.tiles.TileBook;
import noppes.npcs.constants.EnumCompanionTalent;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.constants.EnumRoleType;
import noppes.npcs.containers.ContainerMail;
import noppes.npcs.controllers.PartyController;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.data.BankData;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.controllers.data.Party;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerFactionData;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.controllers.data.PlayerMailData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleCompanion;

public class PacketHandlerPlayer {
    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        ByteBuf buffer = event.packet.payload();
        try {
            this.player(buffer, player, EnumPlayerPacket.values()[buffer.readInt()]);
        }
        catch (IOException e) {
            LogWriter.except(e);
        }
    }

    private void player(ByteBuf buffer, EntityPlayerMP player, EnumPlayerPacket type) throws IOException {
        if (type == EnumPlayerPacket.MarkData) {
            String uuid = Server.readString(buffer);
            if (uuid == null) {
                return;
            }
            Entity entity = NoppesUtilServer.getEntityFromUUID(player.field_70170_p, UUID.fromString(uuid));
            if (!(entity instanceof EntityNPCInterface)) {
                return;
            }
            MarkData markData = MarkData.get((EntityNPCInterface)entity);
        } else if (type == EnumPlayerPacket.CompanionTalentExp) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || npc.advanced.role != EnumRoleType.Companion || player != npc.getOwner()) {
                return;
            }
            int id = buffer.readInt();
            int exp = buffer.readInt();
            RoleCompanion role = (RoleCompanion)npc.roleInterface;
            if (exp <= 0 || !role.canAddExp(-exp) || id < 0 || id >= EnumCompanionTalent.values().length) {
                return;
            }
            EnumCompanionTalent talent = EnumCompanionTalent.values()[id];
            role.addExp(-exp);
            role.addTalentExp(talent, exp);
        } else if (type == EnumPlayerPacket.CompanionOpenInv) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || npc.advanced.role != EnumRoleType.Companion || player != npc.getOwner()) {
                return;
            }
            NoppesUtilServer.sendOpenGui((EntityPlayer)player, EnumGuiType.CompanionInv, npc);
        } else if (type == EnumPlayerPacket.KeyPressed) {
            int[] keysDown;
            if (ScriptController.Instance.languages.isEmpty()) {
                return;
            }
            int button = buffer.readInt();
            boolean isCtrlPressed = buffer.readBoolean();
            boolean isShiftPressed = buffer.readBoolean();
            boolean isAltPressed = buffer.readBoolean();
            boolean isMetaPressed = buffer.readBoolean();
            boolean buttonDown = buffer.readBoolean();
            String ints = Server.readString(buffer);
            String[] split = ints.split(",");
            if (ints.length() > 0) {
                keysDown = new int[split.length];
                try {
                    for (int i = 0; i < split.length; ++i) {
                        keysDown[i] = Integer.parseInt(split[i]);
                    }
                }
                catch (NumberFormatException i) {}
            } else {
                keysDown = new int[]{};
            }
            EventHooks.onPlayerKeyPressed(player, button, isCtrlPressed, isShiftPressed, isAltPressed, isMetaPressed, buttonDown, keysDown);
        } else if (type == EnumPlayerPacket.MouseClicked) {
            int[] keysDown;
            if (ScriptController.Instance.languages.isEmpty()) {
                return;
            }
            int button = buffer.readInt();
            int mouseWheel = buffer.readInt();
            boolean buttonDown = buffer.readBoolean();
            boolean isCtrlPressed = buffer.readBoolean();
            boolean isShiftPressed = buffer.readBoolean();
            boolean isAltPressed = buffer.readBoolean();
            boolean isMetaPressed = buffer.readBoolean();
            String ints = Server.readString(buffer);
            String[] split = ints.split(",");
            if (ints.length() > 0) {
                keysDown = new int[split.length];
                try {
                    for (int i = 0; i < split.length; ++i) {
                        keysDown[i] = Integer.parseInt(split[i]);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                keysDown = new int[]{};
            }
            EventHooks.onPlayerMouseClicked(player, button, mouseWheel, buttonDown, isCtrlPressed, isShiftPressed, isAltPressed, isMetaPressed, keysDown);
        } else if (type == EnumPlayerPacket.FollowerHire) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || npc.advanced.role != EnumRoleType.Follower) {
                return;
            }
            NoppesUtilPlayer.hireFollower(player, npc);
        } else if (type == EnumPlayerPacket.FollowerExtend) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || npc.advanced.role != EnumRoleType.Follower) {
                return;
            }
            NoppesUtilPlayer.extendFollower(player, npc);
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.roleInterface.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPlayerPacket.FollowerState) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || npc.advanced.role != EnumRoleType.Follower) {
                return;
            }
            NoppesUtilPlayer.changeFollowerState(player, npc);
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.roleInterface.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPlayerPacket.RoleGet) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || npc.advanced.role == EnumRoleType.None) {
                return;
            }
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.roleInterface.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPlayerPacket.Transport) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || npc.advanced.role != EnumRoleType.Transporter) {
                return;
            }
            NoppesUtilPlayer.transport(player, npc, Server.readString(buffer));
        } else if (type == EnumPlayerPacket.BankUpgrade) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || npc.advanced.role != EnumRoleType.Bank) {
                return;
            }
            NoppesUtilPlayer.bankUpgrade(player, npc);
        } else if (type == EnumPlayerPacket.BankUnlock) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || npc.advanced.role != EnumRoleType.Bank) {
                return;
            }
            NoppesUtilPlayer.bankUnlock(player, npc);
        } else if (type == EnumPlayerPacket.BankSlotOpen) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null || npc.advanced.role != EnumRoleType.Bank) {
                return;
            }
            int slot = buffer.readInt();
            int bankId = buffer.readInt();
            BankData data = PlayerDataController.Instance.getBankData((EntityPlayer)player, bankId).getBankOrDefault(bankId);
            data.openBankGui((EntityPlayer)player, npc, bankId, slot);
        } else if (type == EnumPlayerPacket.Dialog) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null) {
                return;
            }
            NoppesUtilPlayer.dialogSelected(buffer.readInt(), buffer.readInt(), player, npc);
        } else if (type == EnumPlayerPacket.CheckQuestCompletion) {
            PlayerData playerData = PlayerDataController.Instance.getPlayerData((EntityPlayer)player);
            PlayerQuestData questData = PlayerDataController.Instance.getPlayerData((EntityPlayer)player).questData;
            Party playerParty = playerData.getPlayerParty();
            if (playerParty != null) {
                PartyController.Instance().checkQuestCompletion(playerParty, null);
            }
            questData.checkQuestCompletion(playerData, null);
        } else if (type == EnumPlayerPacket.QuestLog) {
            NoppesUtilPlayer.sendQuestLogData(player);
        } else if (type == EnumPlayerPacket.TrackedQuest) {
            NoppesUtilPlayer.sendTrackedQuest(player);
        } else if (type == EnumPlayerPacket.FactionsGet) {
            PlayerFactionData data = PlayerDataController.Instance.getPlayerData((EntityPlayer)player).factionData;
            Server.sendData(player, EnumPacketClient.GUI_DATA, data.getPlayerGuiData());
        } else if (type == EnumPlayerPacket.MailGet) {
            PlayerMailData data = PlayerDataController.Instance.getPlayerData((EntityPlayer)player).mailData;
            Server.sendData(player, EnumPacketClient.GUI_DATA, data.saveNBTData(new NBTTagCompound()));
        } else if (type == EnumPlayerPacket.MailDelete) {
            long time = buffer.readLong();
            String username = Server.readString(buffer);
            PlayerMailData data = PlayerDataController.Instance.getPlayerData((EntityPlayer)player).mailData;
            Iterator<PlayerMail> it = data.playermail.iterator();
            while (it.hasNext()) {
                PlayerMail mail = it.next();
                if (mail.time != time || !mail.sender.equals(username)) continue;
                it.remove();
            }
            Server.sendData(player, EnumPacketClient.GUI_DATA, data.saveNBTData(new NBTTagCompound()));
        } else if (type == EnumPlayerPacket.MailSend) {
            if (!(player.field_71070_bA instanceof ContainerMail)) {
                return;
            }
            String username = PlayerDataController.Instance.hasPlayer(Server.readString(buffer));
            if (username.isEmpty()) {
                NoppesUtilServer.sendGuiError((EntityPlayer)player, 0);
                return;
            }
            PlayerMail mail = new PlayerMail();
            String s = player.getDisplayName();
            if (!s.equals(player.func_70005_c_())) {
                s = s + "(" + player.func_70005_c_() + ")";
            }
            mail.readNBT(Server.readNBT(buffer));
            mail.sender = s;
            mail.items = ((ContainerMail)player.field_71070_bA).mail.items;
            if (mail.subject.isEmpty()) {
                NoppesUtilServer.sendGuiError((EntityPlayer)player, 1);
                return;
            }
            PlayerDataController.Instance.addPlayerMessage(username, mail);
            NBTTagCompound comp = new NBTTagCompound();
            comp.func_74778_a("username", username);
            NoppesUtilServer.sendGuiClose(player, 1, comp);
        } else if (type == EnumPlayerPacket.MailboxOpenMail) {
            long time = buffer.readLong();
            String username = Server.readString(buffer);
            player.func_71128_l();
            PlayerMailData data = PlayerDataController.Instance.getPlayerData((EntityPlayer)player).mailData;
            for (PlayerMail mail : data.playermail) {
                if (mail.time != time || !mail.sender.equals(username)) continue;
                ContainerMail.staticmail = mail;
                player.openGui((Object)CustomNpcs.instance, EnumGuiType.PlayerMailman.ordinal(), player.field_70170_p, 0, 0, 0);
                break;
            }
        } else if (type == EnumPlayerPacket.MailRead) {
            long time = buffer.readLong();
            String username = Server.readString(buffer);
            PlayerMailData data = PlayerDataController.Instance.getPlayerData((EntityPlayer)player).mailData;
            for (PlayerMail mail : data.playermail) {
                if (mail.time != time || !mail.sender.equals(username)) continue;
                mail.beenRead = true;
                if (!mail.hasQuest()) continue;
                PlayerQuestController.addActiveQuest(new QuestData(mail.getQuest()), (EntityPlayer)player);
            }
        } else if (type == EnumPlayerPacket.SignSave) {
            int z;
            int y;
            int x = buffer.readInt();
            if (player.field_70170_p.func_72899_e(x, y = buffer.readInt(), z = buffer.readInt())) {
                TileEntity tile = player.field_70170_p.func_147438_o(x, y, z);
                if (!(tile instanceof TileBigSign)) {
                    return;
                }
                TileBigSign sign = (TileBigSign)tile;
                if (sign.canEdit) {
                    sign.setText(Server.readString(buffer));
                    sign.canEdit = false;
                    player.field_70170_p.func_147471_g(x, y, z);
                }
            }
        } else if (type == EnumPlayerPacket.SaveBook) {
            int z;
            int y;
            int x = buffer.readInt();
            if (player.field_70170_p.func_72899_e(x, y = buffer.readInt(), z = buffer.readInt())) {
                TileEntity tileentity = player.field_70170_p.func_147438_o(x, y, z);
                if (!(tileentity instanceof TileBook)) {
                    return;
                }
                TileBook tile = (TileBook)tileentity;
                if (tile.book.func_77973_b() == Items.field_151164_bB) {
                    return;
                }
                boolean sign = buffer.readBoolean();
                ItemStack book = ItemStack.func_77949_a((NBTTagCompound)Server.readNBT(buffer));
                if (book == null) {
                    return;
                }
                if (book.func_77973_b() == Items.field_151099_bA && !sign && ItemWritableBook.func_150930_a((NBTTagCompound)book.func_77978_p())) {
                    tile.book.func_77983_a("pages", (NBTBase)book.func_77978_p().func_150295_c("pages", 8));
                }
                if (book.func_77973_b() == Items.field_151164_bB && sign && ItemEditableBook.func_77828_a((NBTTagCompound)book.func_77978_p())) {
                    tile.book.func_77983_a("author", (NBTBase)new NBTTagString(player.func_70005_c_()));
                    tile.book.func_77983_a("title", (NBTBase)new NBTTagString(book.func_77978_p().func_74779_i("title")));
                    tile.book.func_77983_a("pages", (NBTBase)book.func_77978_p().func_150295_c("pages", 8));
                    tile.book.func_150996_a(Items.field_151164_bB);
                }
            }
        } else if (type == EnumPlayerPacket.ScreenSize) {
            int width = buffer.readInt();
            int height = buffer.readInt();
            PlayerDataController.Instance.getPlayerData((EntityPlayer)player).screenSize.setSize(width, height);
        }
    }
}

