/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.world.World;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.client.ClientCacheHandler;
import noppes.npcs.client.ClientEventHandler;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.controllers.ScriptSoundController;
import noppes.npcs.client.gui.player.inventory.GuiCNPCInventory;
import noppes.npcs.client.gui.player.inventory.GuiFaction;
import noppes.npcs.client.gui.player.inventory.GuiParty;
import noppes.npcs.client.gui.player.inventory.GuiQuestLog;
import noppes.npcs.client.gui.player.inventory.GuiSettings;
import noppes.npcs.client.renderer.RenderNPCInterface;
import noppes.npcs.constants.EnumPlayerPacket;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ClientTickHandler {
    private World prevWorld;
    private int prevWidth = 0;
    private int prevHeight = 0;
    private boolean otherContainer = false;
    private int buttonPressed = -1;
    private long buttonTime = 0L;
    private final int[] ignoreKeys = new int[]{157, 29, 54, 42, 184, 56, 220, 219};

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if ((this.prevWorld == null || mc.field_71441_e == null) && this.prevWorld != mc.field_71441_e) {
            ClientCacheHandler.clearCache();
            this.prevWorld = mc.field_71441_e;
        }
        if (event.phase == TickEvent.Phase.END) {
            if (mc.field_71439_g != null && mc.field_71441_e != null && !mc.func_147113_T() && ClientEventHandler.hasOverlays((EntityPlayer)mc.field_71439_g)) {
                ClientEventHandler.renderCNPCPlayer.itemRenderer.func_78441_a();
            }
            return;
        }
        if (mc.field_71439_g != null && mc.field_71439_g.field_71070_bA instanceof ContainerPlayer) {
            if (this.otherContainer) {
                NoppesUtilPlayer.sendData(EnumPlayerPacket.CheckQuestCompletion, new Object[0]);
                this.otherContainer = false;
            }
        } else {
            this.otherContainer = true;
        }
        ++CustomNpcs.ticks;
        ++RenderNPCInterface.LastTextureTick;
        if (this.prevWorld != mc.field_71441_e) {
            this.prevWorld = mc.field_71441_e;
            MusicController.Instance.stopMusic();
        }
        ScriptSoundController.Instance.onUpdate();
        if (Minecraft.func_71410_x().field_71439_g != null && (this.prevWidth != mc.field_71443_c || this.prevHeight != mc.field_71440_d)) {
            this.prevWidth = mc.field_71443_c;
            this.prevHeight = mc.field_71440_d;
            NoppesUtilPlayer.sendData(EnumPlayerPacket.ScreenSize, mc.field_71443_c, mc.field_71440_d);
        }
    }

    @SubscribeEvent
    public void onMouse(InputEvent.MouseInputEvent event) {
        if (Mouse.getEventButton() == -1 && Mouse.getEventDWheel() == 0) {
            return;
        }
        boolean isCtrlPressed = Keyboard.isKeyDown((int)157) || Keyboard.isKeyDown((int)29);
        boolean isShiftPressed = Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42);
        boolean isAltPressed = Keyboard.isKeyDown((int)184) || Keyboard.isKeyDown((int)56);
        boolean isMetaPressed = Keyboard.isKeyDown((int)220) || Keyboard.isKeyDown((int)219);
        StringBuilder keysDownString = new StringBuilder();
        for (int i = 0; i < Keyboard.getKeyCount(); ++i) {
            if (!Keyboard.isKeyDown((int)i)) continue;
            keysDownString.append((Object)i).append(",");
        }
        if (keysDownString.length() > 0) {
            keysDownString.deleteCharAt(keysDownString.length() - 1);
        }
        NoppesUtilPlayer.sendData(EnumPlayerPacket.MouseClicked, Mouse.getEventButton(), Mouse.getEventDWheel(), Mouse.isButtonDown((int)Mouse.getEventButton()), isCtrlPressed, isShiftPressed, isAltPressed, isMetaPressed, keysDownString.toString());
    }

    @SubscribeEvent
    public void onKey(InputEvent.KeyInputEvent event) {
        if (ClientProxy.NPCButton.func_151468_f()) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71462_r == null) {
                switch (GuiCNPCInventory.activeTab) {
                    case 0: {
                        NoppesUtil.openGUI((EntityPlayer)mc.field_71439_g, new GuiQuestLog());
                        break;
                    }
                    case 1: {
                        NoppesUtil.openGUI((EntityPlayer)mc.field_71439_g, new GuiParty());
                        break;
                    }
                    case 2: {
                        NoppesUtil.openGUI((EntityPlayer)mc.field_71439_g, new GuiFaction());
                        break;
                    }
                    case 3: {
                        NoppesUtil.openGUI((EntityPlayer)mc.field_71439_g, new GuiSettings());
                    }
                }
            } else if (mc.field_71462_r instanceof GuiQuestLog) {
                mc.func_71381_h();
            }
        }
        if (!Keyboard.isRepeatEvent()) {
            int key = Keyboard.getEventKey();
            boolean isCtrlPressed = Keyboard.isKeyDown((int)157) || Keyboard.isKeyDown((int)29);
            boolean isShiftPressed = Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42);
            boolean isAltPressed = Keyboard.isKeyDown((int)184) || Keyboard.isKeyDown((int)56);
            boolean isMetaPressed = Keyboard.isKeyDown((int)220) || Keyboard.isKeyDown((int)219);
            boolean keyDown = Keyboard.isKeyDown((int)key);
            StringBuilder keysDownString = new StringBuilder();
            for (int i = 0; i < Keyboard.getKeyCount(); ++i) {
                if (!Keyboard.isKeyDown((int)i)) continue;
                keysDownString.append((Object)i).append(",");
            }
            if (keysDownString.length() > 0) {
                keysDownString.deleteCharAt(keysDownString.length() - 1);
            }
            NoppesUtilPlayer.sendData(EnumPlayerPacket.KeyPressed, key, isCtrlPressed, isShiftPressed, isAltPressed, isMetaPressed, keyDown, keysDownString.toString());
        }
    }

    private boolean isIgnoredKey(int key) {
        for (int i : this.ignoreKeys) {
            if (i != key) continue;
            return true;
        }
        return false;
    }
}

